/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.operations.common;

import infinispan.org.jboss.as.controller.OperationContext;
import infinispan.org.jboss.as.controller.OperationDefinition;
import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.OperationStepHandler;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.SimpleAttributeDefinition;
import infinispan.org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import infinispan.org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import infinispan.org.jboss.as.controller.descriptions.common.ControllerResolver;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.operations.common.Util;
import infinispan.org.jboss.as.controller.operations.validation.ModelTypeValidator;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;
import infinispan.org.jboss.dmr.Property;

public class SchemaLocationRemoveHandler
implements OperationStepHandler {
    private static final String OPERATION_NAME = "remove-schema-location";
    private static final SimpleAttributeDefinition URI = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("uri", ModelType.STRING).setAllowNull(false)).setValidator(new ModelTypeValidator(ModelType.STRING, false))).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("remove-schema-location", ControllerResolver.getResolver("schema-locations")).setParameters(URI).build();
    public static final SchemaLocationRemoveHandler INSTANCE = new SchemaLocationRemoveHandler();

    public static ModelNode getRemoveSchemaLocationOperation(ModelNode address, String schemaURI) {
        ModelNode op = Util.createOperation(OPERATION_NAME, PathAddress.pathAddress(address));
        op.get(URI.getName()).set(schemaURI);
        return op;
    }

    private SchemaLocationRemoveHandler() {
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        ModelNode param = URI.resolveModelAttribute(context, operation);
        ModelNode locations = model.get("schema-locations");
        Property toRemove = null;
        ModelNode newList = new ModelNode().setEmptyList();
        String uri = param.asString();
        if (locations.isDefined()) {
            for (Property location : locations.asPropertyList()) {
                if (uri.equals(location.getName())) {
                    toRemove = location;
                    continue;
                }
                newList.add(location.getName(), location.getValue());
            }
        }
        if (toRemove == null) {
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.schemaNotFound(uri));
        }
        locations.set(newList);
    }
}

