/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.remote;

import infinispan.org.jboss.as.controller.ModelController;
import infinispan.org.jboss.as.controller.client.MessageSeverity;
import infinispan.org.jboss.as.controller.client.OperationAttachments;
import infinispan.org.jboss.as.controller.client.OperationMessageHandler;
import infinispan.org.jboss.as.controller.client.OperationResponse;
import infinispan.org.jboss.as.controller.client.impl.AbstractDelegatingAsyncFuture;
import infinispan.org.jboss.as.controller.client.impl.OperationResponseProxy;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.remote.SecurityActions;
import infinispan.org.jboss.as.controller.remote.SubjectProtocolUtil;
import infinispan.org.jboss.as.controller.remote.TransactionalProtocolClient;
import infinispan.org.jboss.as.controller.remote.TransactionalProtocolHandlers;
import infinispan.org.jboss.as.protocol.StreamUtils;
import infinispan.org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import infinispan.org.jboss.as.protocol.mgmt.ActiveOperation;
import infinispan.org.jboss.as.protocol.mgmt.FlushableDataOutput;
import infinispan.org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import infinispan.org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import infinispan.org.jboss.as.protocol.mgmt.ManagementRequestContext;
import infinispan.org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import infinispan.org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import infinispan.org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import infinispan.org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import infinispan.org.jboss.as.protocol.mgmt.ProtocolUtils;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.threads.AsyncFuture;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Subject;
import org.wildfly.security.manager.WildFlySecurityManager;

class TransactionalProtocolClientImpl
implements ManagementRequestHandlerFactory,
TransactionalProtocolClient {
    private static final File javaTempDir = new File(WildFlySecurityManager.getPropertyPrivileged("java.io.tmpdir", null));
    private final File tempDir;
    private final ManagementChannelAssociation channelAssociation;

    public TransactionalProtocolClientImpl(ManagementChannelAssociation channelAssociation) {
        assert (channelAssociation != null);
        this.channelAssociation = channelAssociation;
        File temp = channelAssociation.getAttachments().getAttachment(ManagementChannelHandler.TEMP_DIR);
        this.tempDir = temp != null && temp.isDirectory() ? temp : javaTempDir;
    }

    @Override
    public ManagementRequestHandler<?, ?> resolveHandler(ManagementRequestHandlerFactory.RequestHandlerChain handlers, ManagementRequestHeader header) {
        byte operationType = header.getOperationId();
        if (operationType == 72) {
            return new HandleReportRequestHandler();
        }
        if (operationType == 76) {
            return ReadAttachmentInputStreamRequestHandler.INSTANCE;
        }
        return handlers.resolveNext();
    }

    @Override
    public AsyncFuture<OperationResponse> execute(TransactionalProtocolClient.TransactionalOperationListener<TransactionalProtocolClient.Operation> listener, ModelNode operation, OperationMessageHandler messageHandler, OperationAttachments attachments) throws IOException {
        TransactionalProtocolClient.Operation wrapper = TransactionalProtocolHandlers.wrap(operation, messageHandler, attachments);
        return this.execute(listener, wrapper);
    }

    @Override
    public <T extends TransactionalProtocolClient.Operation> AsyncFuture<OperationResponse> execute(TransactionalProtocolClient.TransactionalOperationListener<T> listener, T operation) throws IOException {
        Subject subject = SecurityActions.getSubject();
        ExecuteRequestContext context = new ExecuteRequestContext(new OperationWrapper<T>(listener, operation), subject, this.tempDir);
        final ActiveOperation<OperationResponse, ExecuteRequestContext> op = this.channelAssociation.initializeOperation(context, context);
        final AtomicBoolean cancelSent = new AtomicBoolean();
        AbstractDelegatingAsyncFuture<OperationResponse> result = new AbstractDelegatingAsyncFuture<OperationResponse>(op.getResult()){

            @Override
            public synchronized void asyncCancel(boolean interruptionDesired) {
                if (!cancelSent.get()) {
                    try {
                        TransactionalProtocolClientImpl.this.channelAssociation.executeRequest(op, new CompleteTxRequest(113, TransactionalProtocolClientImpl.this.channelAssociation));
                        cancelSent.set(true);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
        context.initialize((AsyncFuture<OperationResponse>)result);
        this.channelAssociation.executeRequest(op, new ExecuteRequest());
        return result;
    }

    private static OperationResponse createOperationResponse(ModelNode simpleResponse, ManagementChannelAssociation channelAssociation, int operationId) {
        ModelNode streamHeader;
        ModelNode modelNode = streamHeader = simpleResponse.hasDefined("response-headers") && simpleResponse.get("response-headers").hasDefined("attached-streams") ? simpleResponse.get("response-headers", "attached-streams") : null;
        if (streamHeader != null && streamHeader.asInt() > 0) {
            return OperationResponseProxy.create(simpleResponse, channelAssociation, operationId, streamHeader);
        }
        return OperationResponse.Factory.createSimple(simpleResponse);
    }

    static ModelNode getFailureResponse(String outcome, String message) {
        ModelNode response = new ModelNode();
        response.get("outcome").set(outcome);
        if (message != null) {
            response.get("failure-description").set(message);
        }
        return response;
    }

    static ModelNode getResponse(String outcome) {
        return TransactionalProtocolClientImpl.getFailureResponse(outcome, null);
    }

    static void writeSubject(FlushableDataOutput output, Subject subject) throws IOException {
        SubjectProtocolUtil.write(output, subject);
    }

    static class PreparedOperationImpl<T extends TransactionalProtocolClient.Operation>
    implements TransactionalProtocolClient.PreparedOperation<T> {
        private final T operation;
        private final ModelNode preparedResult;
        private final AsyncFuture<OperationResponse> finalResult;
        private final ModelController.OperationTransaction transaction;

        protected PreparedOperationImpl(T operation, ModelNode preparedResult, AsyncFuture<OperationResponse> finalResult, ModelController.OperationTransaction transaction) {
            assert (finalResult != null) : "null result";
            this.operation = operation;
            this.preparedResult = preparedResult;
            this.finalResult = finalResult;
            this.transaction = transaction;
        }

        @Override
        public T getOperation() {
            return this.operation;
        }

        @Override
        public ModelNode getPreparedResult() {
            return this.preparedResult;
        }

        @Override
        public boolean isFailed() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.finalResult.isDone();
        }

        @Override
        public AsyncFuture<OperationResponse> getFinalResult() {
            return this.finalResult;
        }

        @Override
        public void commit() {
            this.transaction.commit();
        }

        @Override
        public void rollback() {
            this.transaction.rollback();
        }
    }

    private static class OperationWrapper<T extends TransactionalProtocolClient.Operation> {
        private final T operation;
        private final TransactionalProtocolClient.TransactionalOperationListener<T> listener;
        private AsyncFuture<OperationResponse> future;

        OperationWrapper(TransactionalProtocolClient.TransactionalOperationListener<T> listener, T operation) {
            this.listener = listener;
            this.operation = operation;
        }

        OperationMessageHandler getMessageHandler() {
            return this.operation.getMessageHandler();
        }

        ModelNode getOperation() {
            return this.operation.getOperation();
        }

        OperationAttachments getAttachments() {
            return this.operation.getAttachments();
        }

        void prepared(ModelController.OperationTransaction transaction, ModelNode result) {
            PreparedOperationImpl<T> preparedOperation = new PreparedOperationImpl<T>(this.operation, result, this.future, transaction);
            this.listener.operationPrepared(preparedOperation);
        }

        void completed(OperationResponse response) {
            this.listener.operationComplete(this.operation, response);
        }

        void failed(ModelNode response) {
            this.listener.operationFailed(this.operation, response);
        }
    }

    static class ExecuteRequestContext
    implements ActiveOperation.CompletedCallback<OperationResponse> {
        final OperationWrapper<?> wrapper;
        final AtomicBoolean completed = new AtomicBoolean(false);
        final Subject subject;
        final File tempDir;

        ExecuteRequestContext(OperationWrapper<?> operationWrapper, Subject subject, File tempDir) {
            this.wrapper = operationWrapper;
            this.subject = subject;
            this.tempDir = tempDir;
        }

        void initialize(AsyncFuture<OperationResponse> result) {
            ((OperationWrapper)this.wrapper).future = result;
        }

        OperationMessageHandler getMessageHandler() {
            return this.wrapper.getMessageHandler();
        }

        ModelNode getOperation() {
            return this.wrapper.getOperation();
        }

        OperationAttachments getAttachments() {
            return this.wrapper.getAttachments();
        }

        List<InputStream> getInputStreams() {
            OperationAttachments attachments = this.getAttachments();
            if (attachments == null) {
                return Collections.emptyList();
            }
            return attachments.getInputStreams();
        }

        Subject getSerializableSubject() {
            if (this.subject != null) {
                Subject toSend = new Subject();
                Set<Principal> principals = toSend.getPrincipals();
                for (Principal current : this.subject.getPrincipals()) {
                    if (!(current instanceof Serializable)) continue;
                    principals.add(current);
                }
                toSend.setReadOnly();
                return toSend;
            }
            return null;
        }

        @Override
        public synchronized void completed(OperationResponse result) {
            if (this.completed.compareAndSet(false, true)) {
                this.wrapper.completed(result);
            }
        }

        @Override
        public void failed(Exception e) {
            this.operationFailed(TransactionalProtocolClientImpl.getFailureResponse("failed", e.getMessage()));
        }

        @Override
        public void cancelled() {
            this.operationFailed(TransactionalProtocolClientImpl.getResponse("cancelled"));
        }

        synchronized void operationFailed(ModelNode response) {
            if (this.completed.compareAndSet(false, true)) {
                this.wrapper.failed(response);
            }
        }

        synchronized void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
            this.wrapper.prepared(transaction, result);
        }
    }

    private static class ReadAttachmentInputStreamRequestHandler
    implements ManagementRequestHandler<ModelNode, ExecuteRequestContext> {
        static final ReadAttachmentInputStreamRequestHandler INSTANCE = new ReadAttachmentInputStreamRequestHandler();

        private ReadAttachmentInputStreamRequestHandler() {
        }

        @Override
        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ProtocolUtils.expectHeader(input, 102);
            final int index = input.readInt();
            context.executeAsync(new ManagementRequestContext.AsyncTask<ExecuteRequestContext>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute(ManagementRequestContext<ExecuteRequestContext> context) throws Exception {
                    ExecuteRequestContext exec = context.getAttachment();
                    ManagementRequestHeader header = (ManagementRequestHeader)ManagementRequestHeader.class.cast(context.getRequestHeader());
                    ManagementResponseHeader response = new ManagementResponseHeader(header.getVersion(), header.getRequestId(), null);
                    InputStream is = exec.getAttachments().getInputStreams().get(index);
                    File temp = this.copyStream(is, exec.tempDir);
                    try {
                        FlushableDataOutput output = context.writeMessage(response);
                        try {
                            output.writeByte(103);
                            output.writeInt((int)temp.length());
                            output.writeByte(104);
                            FileInputStream fis = new FileInputStream(temp);
                            try {
                                StreamUtils.copyStream((InputStream)fis, output);
                                fis.close();
                            }
                            finally {
                                StreamUtils.safeClose(fis);
                            }
                            output.writeByte(36);
                            output.close();
                        }
                        finally {
                            StreamUtils.safeClose(output);
                        }
                    }
                    finally {
                        temp.delete();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected File copyStream(InputStream is, File tempDir) throws IOException {
            File temp = File.createTempFile("upload", "temp", tempDir);
            if (is != null) {
                FileOutputStream os = new FileOutputStream(temp);
                try {
                    StreamUtils.copyStream(is, os);
                    os.close();
                }
                finally {
                    StreamUtils.safeClose(os);
                }
            }
            return temp;
        }
    }

    private static class HandleReportRequestHandler
    implements ManagementRequestHandler<ModelNode, ExecuteRequestContext> {
        private HandleReportRequestHandler() {
        }

        @Override
        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ProtocolUtils.expectHeader(input, 98);
            MessageSeverity severity = Enum.valueOf(MessageSeverity.class, input.readUTF());
            ProtocolUtils.expectHeader(input, 99);
            String message = input.readUTF();
            ProtocolUtils.expectHeader(input, 21);
            ExecuteRequestContext requestContext = context.getAttachment();
            OperationMessageHandler handler = requestContext.getMessageHandler();
            handler.handleReport(severity, message);
        }
    }

    private static class CompleteTxRequest
    extends AbstractManagementRequest<OperationResponse, ExecuteRequestContext> {
        private final byte status;
        private final ManagementChannelAssociation channelAssociation;

        private CompleteTxRequest(byte status, ManagementChannelAssociation channelAssociation) {
            this.status = status;
            this.channelAssociation = channelAssociation;
        }

        @Override
        public byte getOperationType() {
            return 78;
        }

        @Override
        public void sendRequest(final ActiveOperation.ResultHandler<OperationResponse> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ControllerLogger.MGMT_OP_LOGGER.tracef("sending CompleteTxRequest for %d", (Object)context.getOperationId());
            context.executeAsync(new ManagementRequestContext.AsyncTask<ExecuteRequestContext>(){

                @Override
                public void execute(ManagementRequestContext<ExecuteRequestContext> context) throws Exception {
                    this.sendRequestInternal(resultHandler, context);
                }
            }, false);
        }

        @Override
        protected void sendRequest(ActiveOperation.ResultHandler<OperationResponse> resultHandler, ManagementRequestContext<ExecuteRequestContext> context, FlushableDataOutput output) throws IOException {
            ControllerLogger.MGMT_OP_LOGGER.tracef("transmitting CompleteTxRequest (%s) for %d", (Object)(this.status != 113 ? 1 : 0), (Object)context.getOperationId());
            output.write(this.status);
        }

        @Override
        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<OperationResponse> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ControllerLogger.MGMT_OP_LOGGER.tracef("received response to CompleteTxRequest (%s) for %d", (Object)(this.status != 113 ? 1 : 0), (Object)context.getOperationId());
            ProtocolUtils.expectHeader(input, 74);
            ModelNode responseNode = new ModelNode();
            responseNode.readExternal(input);
            resultHandler.done(TransactionalProtocolClientImpl.createOperationResponse(responseNode, this.channelAssociation, context.getOperationId()));
        }

        private void sendRequestInternal(ActiveOperation.ResultHandler<OperationResponse> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            super.sendRequest(resultHandler, context);
        }
    }

    private class ExecuteRequest
    extends AbstractManagementRequest<OperationResponse, ExecuteRequestContext> {
        private ExecuteRequest() {
        }

        @Override
        public byte getOperationType() {
            return 71;
        }

        @Override
        public void sendRequest(final ActiveOperation.ResultHandler<OperationResponse> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ControllerLogger.MGMT_OP_LOGGER.tracef("sending ExecuteRequest for %d", (Object)context.getOperationId());
            context.executeAsync(new ManagementRequestContext.AsyncTask<ExecuteRequestContext>(){

                @Override
                public void execute(ManagementRequestContext<ExecuteRequestContext> context) throws Exception {
                    ExecuteRequest.this.sendRequestInternal(resultHandler, context);
                }
            }, false);
        }

        @Override
        protected void sendRequest(ActiveOperation.ResultHandler<OperationResponse> resultHandler, ManagementRequestContext<ExecuteRequestContext> context, FlushableDataOutput output) throws IOException {
            ControllerLogger.MGMT_OP_LOGGER.tracef("transmitting ExecuteRequest for %d", (Object)context.getOperationId());
            ExecuteRequestContext executionContext = context.getAttachment();
            List<InputStream> streams = executionContext.getInputStreams();
            ModelNode operation = executionContext.getOperation();
            int inputStreamLength = 0;
            if (streams != null) {
                inputStreamLength = streams.size();
            }
            output.write(97);
            operation.writeExternal(output);
            output.write(101);
            output.writeInt(inputStreamLength);
            Boolean sendSubject = TransactionalProtocolClientImpl.this.channelAssociation.getAttachments().getAttachment(TransactionalProtocolClient.SEND_SUBJECT);
            if (sendSubject != null && sendSubject.booleanValue()) {
                Subject subject = context.getAttachment().getSerializableSubject();
                TransactionalProtocolClientImpl.writeSubject(output, subject);
            }
        }

        @Override
        public void handleRequest(DataInput input, final ActiveOperation.ResultHandler<OperationResponse> resultHandler, final ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ControllerLogger.MGMT_OP_LOGGER.tracef("received response to ExecuteRequest for %d", (Object)context.getOperationId());
            byte responseType = input.readByte();
            ModelNode response = new ModelNode();
            response.readExternal(input);
            boolean prepared = responseType == 75;
            ExecuteRequestContext executeRequestContext = context.getAttachment();
            if (prepared) {
                executeRequestContext.operationPrepared(new ModelController.OperationTransaction(){

                    @Override
                    public void rollback() {
                        this.done(false);
                    }

                    @Override
                    public void commit() {
                        this.done(true);
                    }

                    private void done(boolean commit) {
                        byte status = commit ? (byte)112 : 113;
                        try {
                            TransactionalProtocolClientImpl.this.channelAssociation.executeRequest(context.getOperationId(), new CompleteTxRequest(status, TransactionalProtocolClientImpl.this.channelAssociation));
                        }
                        catch (Exception e) {
                            resultHandler.failed(e);
                        }
                    }
                }, response);
            } else {
                executeRequestContext.operationFailed(response);
                resultHandler.done(OperationResponse.Factory.createSimple(response));
            }
        }

        private void sendRequestInternal(ActiveOperation.ResultHandler<OperationResponse> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            super.sendRequest(resultHandler, context);
        }
    }
}

