/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.dmr;

import infinispan.org.jboss.dmr.ModelType;
import infinispan.org.jboss.dmr.ModelValue;
import infinispan.org.jboss.dmr.ValueExpression;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

final class DoubleModelValue
extends ModelValue {
    private final double value;

    DoubleModelValue(double value) {
        super(ModelType.DOUBLE);
        this.value = value;
    }

    @Override
    void writeExternal(DataOutput out) throws IOException {
        out.write(ModelType.DOUBLE.typeChar);
        out.writeDouble(this.value);
    }

    @Override
    long asLong() {
        return (long)this.value;
    }

    @Override
    long asLong(long defVal) {
        return (long)this.value;
    }

    @Override
    int asInt() {
        return (int)this.value;
    }

    @Override
    int asInt(int defVal) {
        return (int)this.value;
    }

    @Override
    boolean asBoolean() {
        return this.value != 0.0;
    }

    @Override
    boolean asBoolean(boolean defVal) {
        return this.value != 0.0;
    }

    @Override
    double asDouble() {
        return this.value;
    }

    @Override
    double asDouble(double defVal) {
        return this.value;
    }

    @Override
    byte[] asBytes() {
        long value = Double.doubleToLongBits(this.value);
        byte[] bytes = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return bytes;
    }

    @Override
    BigDecimal asBigDecimal() {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    BigInteger asBigInteger() {
        return BigInteger.valueOf((long)this.value);
    }

    @Override
    String asString() {
        return Double.toString(this.value);
    }

    @Override
    ValueExpression asExpression() {
        return new ValueExpression(this.asString());
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof DoubleModelValue && this.equals((DoubleModelValue)other);
    }

    public boolean equals(DoubleModelValue other) {
        return this == other || other != null && other.value == this.value;
    }

    @Override
    public int hashCode() {
        return Double.valueOf(this.value).hashCode();
    }
}

