/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.SecurityActions;
import org.infinispan.commons.util.Util;

public class ClassFinder {
    private static final Log log = LogFactory.getLog(ClassFinder.class);
    public static final String PATH = SecurityActions.getProperty("java.class.path") + File.pathSeparator + SecurityActions.getProperty("surefire.test.class.path");

    public static List<Class<?>> withAnnotationPresent(List<Class<?>> classes, Class<? extends Annotation> c) {
        ArrayList clazzes = new ArrayList(classes.size());
        for (Class<?> clazz : classes) {
            if (!clazz.isAnnotationPresent(c)) continue;
            clazzes.add(clazz);
        }
        return clazzes;
    }

    public static List<Class<?>> withAnnotationDeclared(List<Class<?>> classes, Class<? extends Annotation> c) {
        ArrayList clazzes = new ArrayList(classes.size());
        for (Class<?> clazz : classes) {
            Annotation[] declaredAnnots;
            if (!clazz.isAnnotationPresent(c)) continue;
            for (Annotation declaredAnnot : declaredAnnots = clazz.getDeclaredAnnotations()) {
                if (!declaredAnnot.annotationType().isAssignableFrom(c)) continue;
                clazzes.add(clazz);
            }
        }
        return clazzes;
    }

    public static List<Class<?>> isAssignableFrom(List<Class<?>> classes, Class<?> clazz) {
        ArrayList clazzes = new ArrayList(classes.size());
        for (Class<?> c : classes) {
            if (!clazz.isAssignableFrom(c)) continue;
            clazzes.add(c);
        }
        return clazzes;
    }

    public static List<Class<?>> withAnnotationPresent(Class<? extends Annotation> ann) throws Exception {
        return ClassFinder.withAnnotationPresent(ClassFinder.infinispanClasses(), ann);
    }

    public static List<Class<?>> isAssignableFrom(Class<?> clazz) throws Exception {
        return ClassFinder.isAssignableFrom(ClassFinder.infinispanClasses(), clazz);
    }

    public static List<Class<?>> infinispanClasses() throws Exception {
        return ClassFinder.infinispanClasses(PATH);
    }

    public static List<Class<?>> infinispanClasses(String javaClassPath) throws Exception {
        ArrayList<File> files = new ArrayList<File>();
        for (String path : javaClassPath.split(File.pathSeparator)) {
            if (!ClassFinder.contains("infinispan", path)) continue;
            files.add(new File(path));
        }
        log.debugf("Looking for infinispan classes in %s", (Object)files);
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet classFiles = new HashSet();
        for (File file : files) {
            classFiles.addAll(ClassFinder.findClassesOnPath(file));
        }
        return new ArrayList(classFiles);
    }

    private static boolean contains(String what, String path) {
        if (path.contains(what)) {
            return true;
        }
        String[] list = new File(path).list();
        if (list == null) {
            return false;
        }
        for (String childPath : list) {
            if (!ClassFinder.contains(what, childPath)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Class<?>> findClassesOnPath(File path) {
        ArrayList classes = new ArrayList();
        if (path.isDirectory()) {
            ArrayList<File> classFiles = new ArrayList<File>();
            ClassFinder.dir(classFiles, path);
            for (File cf : classFiles) {
                String clazz = null;
                try {
                    clazz = ClassFinder.toClassName(cf.getAbsolutePath());
                    Class claz = Util.loadClassStrict(clazz, null);
                    classes.add(claz);
                }
                catch (NoClassDefFoundError ncdfe) {
                    log.warnf("%s has reference to a class %s that could not be loaded from classpath", (Object)cf.getAbsolutePath(), (Object)ncdfe.getMessage());
                }
                catch (Throwable e) {
                    log.warn("On path " + cf.getAbsolutePath() + " could not load class " + clazz, e);
                }
            }
        } else if (path.isFile() && path.getName().endsWith("jar") && path.canRead()) {
            JarFile jar;
            try {
                jar = new JarFile(path);
            }
            catch (Exception ex) {
                log.warnf("Could not create jar file on path %s", (Object)path);
                return classes;
            }
            try {
                Enumeration<JarEntry> en = jar.entries();
                while (en.hasMoreElements()) {
                    JarEntry entry = en.nextElement();
                    if (!entry.getName().endsWith("class")) continue;
                    String clazz = null;
                    try {
                        clazz = ClassFinder.toClassName(entry.getName());
                        Class claz = Util.loadClassStrict(clazz, null);
                        classes.add(claz);
                    }
                    catch (NoClassDefFoundError ncdfe) {
                        log.warnf("%s has reference to a class %s that could not be loaded from classpath", (Object)entry.getName(), (Object)ncdfe.getMessage());
                    }
                    catch (Throwable e) {
                        log.warn("From jar path " + entry.getName() + " could not load class " + clazz, e);
                    }
                }
            }
            finally {
                try {
                    jar.close();
                }
                catch (IOException e) {
                    log.debugf((Throwable)e, "error closing jar file %s", (Object)jar);
                }
            }
        }
        return classes;
    }

    private static void dir(List<File> files, File dir) {
        File[] entries = dir.listFiles();
        if (entries != null) {
            for (File entry : entries) {
                if (entry.isDirectory()) {
                    ClassFinder.dir(files, entry);
                    continue;
                }
                if (!entry.getName().endsWith("class")) continue;
                files.add(entry);
            }
        }
    }

    private static String toClassName(String fileName) {
        return fileName.substring(fileName.lastIndexOf("org" + File.separator), fileName.length() - 6).replace(File.separator, ".");
    }
}

