/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller;

import infinispan.org.jboss.as.controller.BlockingTimeout;
import infinispan.org.jboss.as.controller.ModelVersion;
import infinispan.org.jboss.as.controller.OperationContext;
import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.ProxyController;
import infinispan.org.jboss.as.controller.ProxyOperationAddressTranslator;
import infinispan.org.jboss.as.controller.client.OperationAttachments;
import infinispan.org.jboss.as.controller.client.OperationMessageHandler;
import infinispan.org.jboss.as.controller.registry.Resource;
import infinispan.org.jboss.as.controller.remote.RemoteProxyController;
import infinispan.org.jboss.as.controller.remote.TransactionalProtocolClient;
import infinispan.org.jboss.as.controller.remote.TransactionalProtocolHandlers;
import infinispan.org.jboss.as.controller.transform.OperationTransformer;
import infinispan.org.jboss.as.controller.transform.ResourceTransformationContext;
import infinispan.org.jboss.as.controller.transform.TransformationContext;
import infinispan.org.jboss.as.controller.transform.TransformationTarget;
import infinispan.org.jboss.as.controller.transform.Transformers;
import infinispan.org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import infinispan.org.jboss.dmr.ModelNode;

public interface TransformingProxyController
extends ProxyController {
    public TransactionalProtocolClient getProtocolClient();

    public Transformers getTransformers();

    public OperationTransformer.TransformedOperation transformOperation(OperationContext var1, ModelNode var2) throws OperationFailedException;

    public OperationTransformer.TransformedOperation transformOperation(Transformers.TransformationInputs var1, ModelNode var2) throws OperationFailedException;

    public static class Factory {
        public static TransformingProxyController create(ManagementChannelHandler channelAssociation, Transformers transformers, PathAddress pathAddress, ProxyOperationAddressTranslator addressTranslator) {
            TransactionalProtocolClient client = TransactionalProtocolHandlers.createClient(channelAssociation);
            return Factory.create(client, transformers, pathAddress, addressTranslator);
        }

        public static TransformingProxyController create(TransactionalProtocolClient client, final Transformers transformers, PathAddress pathAddress, ProxyOperationAddressTranslator addressTranslator) {
            ModelVersion targetKernelVersion = transformers.getTarget().getVersion();
            final RemoteProxyController proxy = RemoteProxyController.create(client, pathAddress, addressTranslator, targetKernelVersion);
            Transformers delegating = new Transformers(){

                @Override
                public TransformationTarget getTarget() {
                    return transformers.getTarget();
                }

                @Override
                public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, ModelNode original) throws OperationFailedException {
                    ModelNode operation = proxy.translateOperationForProxy(original);
                    return transformers.transformOperation(context, operation);
                }

                @Override
                public Resource transformResource(ResourceTransformationContext context, Resource resource) throws OperationFailedException {
                    return transformers.transformResource(context, resource);
                }

                @Override
                public OperationTransformer.TransformedOperation transformOperation(Transformers.TransformationInputs transformationParameters, ModelNode original) throws OperationFailedException {
                    ModelNode operation = proxy.translateOperationForProxy(original);
                    return transformers.transformOperation(transformationParameters, operation);
                }

                @Override
                public Resource transformRootResource(Transformers.TransformationInputs transformationParameters, Resource resource) throws OperationFailedException {
                    return transformers.transformRootResource(transformationParameters, resource);
                }

                @Override
                public Resource transformRootResource(Transformers.TransformationInputs transformationParameters, Resource resource, Transformers.ResourceIgnoredTransformationRegistry ignoredTransformationRegistry) throws OperationFailedException {
                    return transformers.transformRootResource(transformationParameters, resource, ignoredTransformationRegistry);
                }
            };
            return Factory.create(proxy, delegating);
        }

        private static TransformingProxyController create(RemoteProxyController delegate, Transformers transformers) {
            return new TransformingProxyControllerImpl(transformers, delegate);
        }

        private static class TransformingProxyControllerImpl
        implements TransformingProxyController {
            private final RemoteProxyController proxy;
            private final Transformers transformers;

            public TransformingProxyControllerImpl(Transformers transformers, RemoteProxyController proxy) {
                this.transformers = transformers;
                this.proxy = proxy;
            }

            @Override
            public TransactionalProtocolClient getProtocolClient() {
                return this.proxy.getTransactionalProtocolClient();
            }

            @Override
            public Transformers getTransformers() {
                return this.transformers;
            }

            @Override
            public PathAddress getProxyNodeAddress() {
                return this.proxy.getProxyNodeAddress();
            }

            @Override
            public OperationTransformer.TransformedOperation transformOperation(OperationContext context, ModelNode operation) throws OperationFailedException {
                return this.transformOperation(Transformers.TransformationInputs.getOrCreate(context), operation);
            }

            @Override
            public OperationTransformer.TransformedOperation transformOperation(Transformers.TransformationInputs parameters, ModelNode operation) throws OperationFailedException {
                ModelNode transformedOp;
                ModelNode operationHeaders = operation.hasDefined("operation-headers") ? operation.get("operation-headers") : null;
                OperationTransformer.TransformedOperation transformed = this.transformers.transformOperation(parameters, operation);
                if (operationHeaders != null && (transformedOp = transformed.getTransformedOperation()) != null && !transformedOp.hasDefined("operation-headers")) {
                    transformedOp.get("operation-headers").set(operationHeaders);
                }
                return transformed;
            }

            @Override
            public void execute(ModelNode operation, OperationMessageHandler handler, ProxyController.ProxyOperationControl control, OperationAttachments attachments, BlockingTimeout blockingTimeout) {
                this.proxy.execute(operation, handler, control, attachments, blockingTimeout);
            }

            @Override
            public ModelVersion getKernelModelVersion() {
                return this.proxy.getKernelModelVersion();
            }
        }
    }
}

