/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.transform;

import infinispan.org.jboss.as.controller.AttributeDefinition;
import infinispan.org.jboss.as.controller.ModelVersion;
import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.PathElement;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.registry.Resource;
import infinispan.org.jboss.as.controller.transform.OperationRejectionPolicy;
import infinispan.org.jboss.as.controller.transform.OperationResultTransformer;
import infinispan.org.jboss.as.controller.transform.OperationTransformer;
import infinispan.org.jboss.as.controller.transform.ResourceTransformationContext;
import infinispan.org.jboss.as.controller.transform.ResourceTransformer;
import infinispan.org.jboss.as.controller.transform.TransformationContext;
import infinispan.org.jboss.as.controller.transform.TransformationTarget;
import infinispan.org.jboss.dmr.ModelNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DiscardUndefinedAttributesTransformer
implements ResourceTransformer,
OperationTransformer {
    private final Set<String> attributeNames;
    private final OperationTransformer writeAttributeTransformer = new WriteAttributeTransformer();
    private final OperationTransformer undefineAttributeTransformer = new UndefineAttributeTransformer();

    public DiscardUndefinedAttributesTransformer(AttributeDefinition ... attributes) {
        this(DiscardUndefinedAttributesTransformer.namesFromDefinitions(attributes));
    }

    private static Set<String> namesFromDefinitions(AttributeDefinition ... attributes) {
        HashSet<String> names = new HashSet<String>();
        for (AttributeDefinition def : attributes) {
            names.add(def.getName());
        }
        return names;
    }

    public DiscardUndefinedAttributesTransformer(String ... attributeNames) {
        this(new HashSet<String>(Arrays.asList(attributeNames)));
    }

    public DiscardUndefinedAttributesTransformer(Set<String> attributeNames) {
        this.attributeNames = attributeNames;
    }

    public OperationTransformer getWriteAttributeTransformer() {
        return this.writeAttributeTransformer;
    }

    public OperationTransformer getUndefineAttributeTransformer() {
        return this.undefineAttributeTransformer;
    }

    @Override
    public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
        this.transformResourceInt(context, address, resource);
        ResourceTransformationContext childContext = context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource);
        childContext.processChildren(resource);
    }

    @Override
    public OperationTransformer.TransformedOperation transformOperation(final TransformationContext context, final PathAddress address, final ModelNode operation) throws OperationFailedException {
        final Set<String> problems = this.checkModelNode(operation);
        boolean reject = problems != null;
        OperationRejectionPolicy rejectPolicy = reject ? new OperationRejectionPolicy(){

            @Override
            public boolean rejectOperation(ModelNode preparedResult) {
                return true;
            }

            @Override
            public String getFailureDescription() {
                return context.getLogger().getAttributeWarning(address, operation, problems);
            }
        } : OperationTransformer.DEFAULT_REJECTION_POLICY;
        return new OperationTransformer.TransformedOperation(operation, rejectPolicy, OperationResultTransformer.ORIGINAL_RESULT);
    }

    private void transformResourceInt(TransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
        Set<String> problems = this.checkModelNode(resource.getModel());
        if (problems != null) {
            if (context.getTarget().isIgnoredResourceListAvailableAtRegistration()) {
                ModelVersion usedVersion;
                List<String> msg = Collections.singletonList(context.getLogger().getAttributeWarning(address, null, problems));
                TransformationTarget tgt = context.getTarget();
                String legacyHostName = tgt.getHostName();
                ModelVersion coreVersion = tgt.getVersion();
                String subsystemName = DiscardUndefinedAttributesTransformer.findSubsystemName(address);
                ModelVersion modelVersion = usedVersion = subsystemName == null ? coreVersion : tgt.getSubsystemVersion(subsystemName);
                if (subsystemName != null) {
                    throw ControllerLogger.ROOT_LOGGER.rejectAttributesSubsystemModelResourceTransformer(address, legacyHostName, subsystemName, usedVersion, msg);
                }
                throw ControllerLogger.ROOT_LOGGER.rejectAttributesCoreModelResourceTransformer(address, legacyHostName, usedVersion, msg);
            }
            context.getLogger().logAttributeWarning(address, problems);
        }
    }

    private static String findSubsystemName(PathAddress pathAddress) {
        for (PathElement element : pathAddress) {
            if (!element.getKey().equals("subsystem")) continue;
            return element.getValue();
        }
        return null;
    }

    private Set<String> checkModelNode(ModelNode modelNode) {
        HashSet<String> problems = null;
        for (String attr : this.attributeNames) {
            if (!modelNode.has(attr)) continue;
            if (modelNode.hasDefined(attr)) {
                if (problems == null) {
                    problems = new HashSet<String>();
                }
                problems.add(attr);
                continue;
            }
            modelNode.remove(attr);
        }
        return problems;
    }

    private class UndefineAttributeTransformer
    implements OperationTransformer {
        private UndefineAttributeTransformer() {
        }

        @Override
        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            String attribute = operation.require("name").asString();
            if (DiscardUndefinedAttributesTransformer.this.attributeNames.contains(attribute)) {
                return OperationTransformer.DISCARD.transformOperation(context, address, operation);
            }
            return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
        }
    }

    private class WriteAttributeTransformer
    implements OperationTransformer {
        private WriteAttributeTransformer() {
        }

        @Override
        public OperationTransformer.TransformedOperation transformOperation(final TransformationContext context, final PathAddress address, final ModelNode operation) throws OperationFailedException {
            boolean rejectResult;
            final String attribute = operation.require("name").asString();
            boolean ourAttribute = DiscardUndefinedAttributesTransformer.this.attributeNames.contains(attribute);
            boolean bl = rejectResult = ourAttribute && operation.hasDefined("value");
            if (rejectResult) {
                OperationRejectionPolicy rejectPolicy = new OperationRejectionPolicy(){

                    @Override
                    public boolean rejectOperation(ModelNode preparedResult) {
                        return true;
                    }

                    @Override
                    public String getFailureDescription() {
                        return context.getLogger().getAttributeWarning(address, operation, attribute);
                    }
                };
                return new OperationTransformer.TransformedOperation(operation, rejectPolicy, OperationResultTransformer.ORIGINAL_RESULT);
            }
            if (ourAttribute) {
                return OperationTransformer.DISCARD.transformOperation(context, address, operation);
            }
            return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
        }
    }
}

