/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.modules;

import infinispan.org.jboss.modules.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

final class FileEntryResource
implements Resource {
    private final String name;
    private final File file;
    private final URL url;
    private final AccessControlContext context;

    FileEntryResource(String name, File file, URL url, AccessControlContext context) {
        this.name = name;
        this.file = file;
        this.url = url;
        this.context = context;
    }

    @Override
    public long getSize() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Long>(){

                @Override
                public Long run() {
                    return FileEntryResource.this.file.length();
                }
            }, this.context);
        }
        return this.file.length();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public InputStream openStream() throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                    @Override
                    public FileInputStream run() throws IOException {
                        return new FileInputStream(FileEntryResource.this.file);
                    }
                }, this.context);
            }
            catch (PrivilegedActionException e) {
                try {
                    throw e.getException();
                }
                catch (RuntimeException e1) {
                    throw e1;
                }
                catch (IOException e1) {
                    throw e1;
                }
                catch (Exception e1) {
                    throw new UndeclaredThrowableException(e1);
                }
            }
        }
        return new FileInputStream(this.file);
    }
}

