/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.modules;

import infinispan.org.jboss.modules.JarModuleFinder;
import infinispan.org.jboss.modules.Module;
import infinispan.org.jboss.modules.ModuleFinder;
import infinispan.org.jboss.modules.ModuleIdentifier;
import infinispan.org.jboss.modules.ModuleLoadException;
import infinispan.org.jboss.modules.ModuleLoader;
import java.io.File;
import java.util.jar.JarFile;

final class JarModuleLoader
extends ModuleLoader {
    static final String[] NO_STRINGS = new String[0];
    private final ModuleLoader delegate;
    private final JarFile jarFile;
    private final ModuleIdentifier myIdentifier;

    JarModuleLoader(ModuleLoader delegate, JarFile jarFile) {
        super(new ModuleFinder[]{new JarModuleFinder(JarModuleLoader.simpleNameOf(jarFile), jarFile)});
        this.delegate = delegate;
        this.jarFile = jarFile;
        this.myIdentifier = JarModuleLoader.simpleNameOf(jarFile);
    }

    private static ModuleIdentifier simpleNameOf(JarFile jarFile) {
        String jarName = jarFile.getName();
        String simpleJarName = jarName.substring(jarName.lastIndexOf(File.separatorChar) + 1);
        return ModuleIdentifier.create(simpleJarName);
    }

    @Override
    protected Module preloadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        if (identifier.equals(this.myIdentifier)) {
            return this.loadModuleLocal(identifier);
        }
        Module module = this.loadModuleLocal(identifier);
        if (module == null) {
            return JarModuleLoader.preloadModule(identifier, this.delegate);
        }
        return module;
    }

    ModuleIdentifier getMyIdentifier() {
        return this.myIdentifier;
    }

    @Override
    public String toString() {
        return "JAR module loader";
    }
}

