/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.modules.filter;

import infinispan.org.jboss.modules.filter.PathFilter;
import java.util.Arrays;

final class AggregatePathFilter
implements PathFilter {
    private final PathFilter[] delegates;
    private final boolean any;
    private final int hashCode;

    AggregatePathFilter(boolean any, PathFilter ... delegates) {
        this.any = any;
        this.delegates = delegates;
        this.hashCode = Boolean.valueOf(any).hashCode() ^ Arrays.hashCode(delegates);
    }

    @Override
    public boolean accept(String path) {
        for (PathFilter filter : this.delegates) {
            if (filter.accept(path) != this.any) continue;
            return this.any;
        }
        return !this.any;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof AggregatePathFilter && this.equals((AggregatePathFilter)obj);
    }

    public boolean equals(AggregatePathFilter obj) {
        return obj != null && obj.any == this.any && Arrays.equals(obj.delegates, this.delegates);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.any ? "Any " : "All ").append("of (");
        for (int idx = 0; idx < this.delegates.length; ++idx) {
            PathFilter delegate = this.delegates[idx];
            b.append(delegate);
            if (idx >= this.delegates.length - 1) continue;
            b.append(',');
        }
        b.append(')');
        return b.toString();
    }
}

