/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.query;

import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.query.RemoteQueryBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.impl.BaseQueryFactory;
import org.infinispan.query.remote.client.MarshallerRegistration;
import org.infinispan.query.remote.client.QueryRequest;

public final class RemoteQueryFactory
extends BaseQueryFactory {
    private final RemoteCacheImpl cache;
    private final SerializationContext serializationContext;

    public RemoteQueryFactory(RemoteCacheImpl cache) {
        this.serializationContext = ProtoStreamMarshaller.getSerializationContext(cache.getRemoteCacheManager());
        this.cache = cache;
        try {
            if (!this.serializationContext.canMarshall(QueryRequest.class)) {
                MarshallerRegistration.registerMarshallers(this.serializationContext);
            }
        }
        catch (Exception e) {
            throw new HotRodClientException("Failed to initialise the Protobuf serialization context", e);
        }
    }

    @Override
    public QueryBuilder from(Class entityType) {
        String typeName = this.serializationContext.getMarshaller(entityType).getTypeName();
        return new RemoteQueryBuilder(this, this.cache, this.serializationContext, typeName);
    }

    @Override
    public QueryBuilder from(String entityType) {
        this.serializationContext.getMarshaller(entityType);
        return new RemoteQueryBuilder(this, this.cache, this.serializationContext, entityType);
    }
}

