/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import infinispan.org.jboss.modules.Module;
import infinispan.org.jboss.modules.ModuleIdentifier;
import infinispan.org.jboss.modules.ModuleLoadException;
import infinispan.org.jboss.modules.ModuleLoader;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.StreamCorruptedException;
import java.lang.reflect.Proxy;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;

public final class ModularClassTable
implements ClassTable {
    private static final ClassTable.Writer PROXY_WRITER = new ProxyWriter();
    private static final ClassTable.Writer CLASS_WRITER = new ClassWriter();
    private final ModuleLoader moduleLoader;

    private ModularClassTable(ModuleLoader moduleLoader) {
        this.moduleLoader = moduleLoader;
    }

    public static ModularClassTable getInstance(ModuleLoader moduleLoader) {
        return new ModularClassTable(moduleLoader);
    }

    @Override
    public ClassTable.Writer getClassWriter(Class<?> clazz) throws IOException {
        return Proxy.isProxyClass(clazz) ? PROXY_WRITER : CLASS_WRITER;
    }

    @Override
    public Class<?> readClass(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        byte b = unmarshaller.readByte();
        switch (b) {
            case 0: {
                String className;
                ClassLoader classLoader;
                String name = (String)unmarshaller.readObject();
                if (name == null) {
                    classLoader = Module.class.getClassLoader();
                    className = (String)unmarshaller.readObject();
                } else {
                    String slot = (String)unmarshaller.readObject();
                    ModuleIdentifier identifier = ModuleIdentifier.create(name, slot);
                    className = (String)unmarshaller.readObject();
                    try {
                        classLoader = this.moduleLoader.loadModule(identifier).getClassLoader();
                    }
                    catch (ModuleLoadException e) {
                        InvalidClassException ce = new InvalidClassException(className, "Module load failed");
                        ce.initCause(e);
                        throw ce;
                    }
                }
                return Class.forName(className, false, classLoader);
            }
            case 1: {
                ClassLoader classLoader;
                String name = (String)unmarshaller.readObject();
                if (name == null) {
                    classLoader = Module.class.getClassLoader();
                } else {
                    Module module;
                    String slot = (String)unmarshaller.readObject();
                    ModuleIdentifier identifier = ModuleIdentifier.create(name, slot);
                    try {
                        module = this.moduleLoader.loadModule(identifier);
                    }
                    catch (ModuleLoadException e) {
                        InvalidClassException ce = new InvalidClassException("Module load failed");
                        ce.initCause(e);
                        throw ce;
                    }
                    classLoader = module.getClassLoader();
                }
                int len = unmarshaller.readInt();
                Class[] interfaces = new Class[len];
                for (int i = 0; i < len; ++i) {
                    interfaces[i] = Class.forName((String)unmarshaller.readObject(), false, classLoader);
                }
                return Proxy.getProxyClass(classLoader, interfaces);
            }
        }
        throw new StreamCorruptedException(String.format("Invalid class type byte: %02x", b & 0xFF));
    }

    private static final class ProxyWriter
    implements ClassTable.Writer {
        private ProxyWriter() {
        }

        @Override
        public void writeClass(Marshaller marshaller, Class<?> clazz) throws IOException {
            marshaller.write(1);
            Module module = Module.forClass(clazz);
            if (module == null) {
                marshaller.writeObject(null);
            } else {
                ModuleIdentifier identifier = module.getIdentifier();
                marshaller.writeObject(identifier.getName());
                marshaller.writeObject(identifier.getSlot());
            }
            Class<?>[] interfaces = clazz.getInterfaces();
            marshaller.writeInt(interfaces.length);
            for (Class<?> interfaze : interfaces) {
                marshaller.writeObject(interfaze.getName());
            }
        }
    }

    private static final class ClassWriter
    implements ClassTable.Writer {
        private ClassWriter() {
        }

        @Override
        public void writeClass(Marshaller marshaller, Class<?> clazz) throws IOException {
            marshaller.write(0);
            Module module = Module.forClass(clazz);
            if (module == null) {
                marshaller.writeObject(null);
            } else {
                ModuleIdentifier identifier = module.getIdentifier();
                marshaller.writeObject(identifier.getName());
                marshaller.writeObject(identifier.getSlot());
            }
            marshaller.writeObject(clazz.getName());
        }
    }
}

