/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.threads;

import infinispan.org.jboss.threads.DirectExecutor;

class ThreadNameExecutor
implements DirectExecutor {
    private final String newName;
    private final DirectExecutor delegate;

    ThreadNameExecutor(String newName, DirectExecutor delegate) {
        this.newName = newName;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        Thread thr = Thread.currentThread();
        String oldName = thr.getName();
        thr.setName(this.newName);
        try {
            this.delegate.execute(command);
        }
        finally {
            thr.setName(oldName);
        }
    }

    public String toString() {
        return String.format("%s name=\"%s\" -> %s", super.toString(), this.newName, this.delegate);
    }
}

