/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.ServerStatistics;
import org.infinispan.client.hotrod.Version;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.event.ClientListenerNotifier;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.RemoteCacheManagerNotStartedException;
import org.infinispan.client.hotrod.filter.Filters;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;
import org.infinispan.client.hotrod.impl.RemoteCacheSupport;
import org.infinispan.client.hotrod.impl.ServerStatisticsImpl;
import org.infinispan.client.hotrod.impl.VersionedOperationResponse;
import org.infinispan.client.hotrod.impl.VersionedValueImpl;
import org.infinispan.client.hotrod.impl.iteration.RemoteCloseableIterator;
import org.infinispan.client.hotrod.impl.operations.AddClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.BulkGetKeysOperation;
import org.infinispan.client.hotrod.impl.operations.BulkGetOperation;
import org.infinispan.client.hotrod.impl.operations.ClearOperation;
import org.infinispan.client.hotrod.impl.operations.ContainsKeyOperation;
import org.infinispan.client.hotrod.impl.operations.ExecuteOperation;
import org.infinispan.client.hotrod.impl.operations.GetAllParallelOperation;
import org.infinispan.client.hotrod.impl.operations.GetOperation;
import org.infinispan.client.hotrod.impl.operations.GetWithMetadataOperation;
import org.infinispan.client.hotrod.impl.operations.GetWithVersionOperation;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.operations.PingOperation;
import org.infinispan.client.hotrod.impl.operations.PutAllParallelOperation;
import org.infinispan.client.hotrod.impl.operations.PutIfAbsentOperation;
import org.infinispan.client.hotrod.impl.operations.PutOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceOperation;
import org.infinispan.client.hotrod.impl.operations.SizeOperation;
import org.infinispan.client.hotrod.impl.operations.StatsOperation;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.query.dsl.Query;

public class RemoteCacheImpl<K, V>
extends RemoteCacheSupport<K, V> {
    private static final Log log = LogFactory.getLog(RemoteCacheImpl.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private Marshaller marshaller;
    private final String name;
    private final RemoteCacheManager remoteCacheManager;
    private volatile ExecutorService executorService;
    protected OperationsFactory operationsFactory;
    private int estimateKeySize;
    private int estimateValueSize;
    private volatile boolean hasCompatibility;

    public RemoteCacheImpl(RemoteCacheManager rcm, String name) {
        if (trace) {
            log.tracef("Creating remote cache: %s", (Object)name);
        }
        this.name = name;
        this.remoteCacheManager = rcm;
    }

    public void init(Marshaller marshaller, ExecutorService executorService, OperationsFactory operationsFactory, int estimateKeySize, int estimateValueSize) {
        this.marshaller = marshaller;
        this.executorService = executorService;
        this.operationsFactory = operationsFactory;
        this.estimateKeySize = estimateKeySize;
        this.estimateValueSize = estimateValueSize;
    }

    public OperationsFactory getOperationsFactory() {
        return this.operationsFactory;
    }

    @Override
    public RemoteCacheManager getRemoteCacheManager() {
        return this.remoteCacheManager;
    }

    @Override
    public boolean removeWithVersion(K key, long version) {
        this.assertRemoteCacheManagerIsStarted();
        RemoveIfUnmodifiedOperation op = this.operationsFactory.newRemoveIfUnmodifiedOperation(this.compatKeyIfNeeded(key), this.obj2bytes(key, true), version);
        VersionedOperationResponse response = (VersionedOperationResponse)op.execute();
        return response.getCode().isUpdated();
    }

    @Override
    public CompletableFuture<Boolean> removeWithVersionAsync(K key, long version) {
        this.assertRemoteCacheManagerIsStarted();
        return CompletableFuture.supplyAsync(() -> this.removeWithVersion(key, version), this.executorService);
    }

    @Override
    public boolean replaceWithVersion(K key, V newValue, long version, int lifespanSeconds, int maxIdleTimeSeconds) {
        return this.replaceWithVersion(key, newValue, version, lifespanSeconds, TimeUnit.SECONDS, maxIdleTimeSeconds, TimeUnit.SECONDS);
    }

    @Override
    public boolean replaceWithVersion(K key, V newValue, long version, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        this.assertRemoteCacheManagerIsStarted();
        ReplaceIfUnmodifiedOperation op = this.operationsFactory.newReplaceIfUnmodifiedOperation(this.compatKeyIfNeeded(key), this.obj2bytes(key, true), this.obj2bytes(newValue, false), lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit, version);
        VersionedOperationResponse response = (VersionedOperationResponse)op.execute();
        return response.getCode().isUpdated();
    }

    @Override
    public CompletableFuture<Boolean> replaceWithVersionAsync(K key, V newValue, long version, int lifespanSeconds, int maxIdleSeconds) {
        this.assertRemoteCacheManagerIsStarted();
        return CompletableFuture.supplyAsync(() -> this.replaceWithVersion(key, newValue, version, lifespanSeconds, maxIdleSeconds), this.executorService);
    }

    @Override
    public CloseableIterator<Map.Entry<Object, Object>> retrieveEntries(String filterConverterFactory, Object[] filterConverterParams, Set<Integer> segments, int batchSize) {
        this.assertRemoteCacheManagerIsStarted();
        if (segments != null && segments.isEmpty()) {
            return new CloseableIterator<Map.Entry<Object, Object>>(){

                @Override
                public void close() {
                }

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public Map.Entry<Object, Object> next() {
                    throw new NoSuchElementException();
                }
            };
        }
        byte[][] params = this.marshallParams(filterConverterParams);
        RemoteCloseableIterator<Object> remoteCloseableIterator = new RemoteCloseableIterator<Object>(this.operationsFactory, filterConverterFactory, params, segments, batchSize, false);
        remoteCloseableIterator.start();
        return remoteCloseableIterator;
    }

    @Override
    public CloseableIterator<Map.Entry<Object, Object>> retrieveEntries(String filterConverterFactory, Set<Integer> segments, int batchSize) {
        return this.retrieveEntries(filterConverterFactory, null, segments, batchSize);
    }

    @Override
    public CloseableIterator<Map.Entry<Object, Object>> retrieveEntries(String filterConverterFactory, int batchSize) {
        return this.retrieveEntries(filterConverterFactory, null, batchSize);
    }

    @Override
    public CloseableIterator<Map.Entry<Object, Object>> retrieveEntriesByQuery(Query filterQuery, Set<Integer> segments, int batchSize) {
        Object[] factoryParams = Filters.makeFactoryParams(filterQuery);
        return this.retrieveEntries("iteration-filter-converter-factory", factoryParams, segments, batchSize);
    }

    @Override
    public CloseableIterator<Map.Entry<Object, MetadataValue<Object>>> retrieveEntriesWithMetadata(Set<Integer> segments, int batchSize) {
        RemoteCloseableIterator<MetadataValue<Object>> remoteCloseableIterator = new RemoteCloseableIterator<MetadataValue<Object>>(this.operationsFactory, batchSize, segments, true);
        remoteCloseableIterator.start();
        return remoteCloseableIterator;
    }

    @Override
    public VersionedValue<V> getVersioned(K key) {
        this.assertRemoteCacheManagerIsStarted();
        if (ConfigurationProperties.isVersionPre12(this.remoteCacheManager.getConfiguration())) {
            GetWithVersionOperation op = this.operationsFactory.newGetWithVersionOperation(this.compatKeyIfNeeded(key), this.obj2bytes(key, true));
            return (VersionedValue)op.execute();
        }
        MetadataValue<V> result = this.getWithMetadata(key);
        return result != null ? new VersionedValueImpl(result.getVersion(), result.getValue()) : null;
    }

    @Override
    public MetadataValue<V> getWithMetadata(K key) {
        this.assertRemoteCacheManagerIsStarted();
        GetWithMetadataOperation op = this.operationsFactory.newGetWithMetadataOperation(this.compatKeyIfNeeded(key), this.obj2bytes(key, true));
        return (MetadataValue)op.execute();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.assertRemoteCacheManagerIsStarted();
        if (trace) {
            log.tracef("About to putAll entries (%s) lifespan:%d (%s), maxIdle:%d (%s)", new Object[]{map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit});
        }
        HashMap<byte[], byte[]> byteMap = new HashMap<byte[], byte[]>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            byteMap.put(this.obj2bytes(entry.getKey(), true), this.obj2bytes(entry.getValue(), false));
        }
        PutAllParallelOperation op = this.operationsFactory.newPutAllOperation(byteMap, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        op.execute();
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.assertRemoteCacheManagerIsStarted();
        return CompletableFuture.supplyAsync(() -> {
            this.putAll(data, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
            return null;
        }, this.executorService);
    }

    @Override
    public int size() {
        this.assertRemoteCacheManagerIsStarted();
        SizeOperation op = this.operationsFactory.newSizeOperation();
        return (Integer)op.execute();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ServerStatistics stats() {
        this.assertRemoteCacheManagerIsStarted();
        StatsOperation op = this.operationsFactory.newStatsOperation();
        Map statsMap = (Map)op.execute();
        ServerStatisticsImpl stats = new ServerStatisticsImpl();
        for (Map.Entry entry : statsMap.entrySet()) {
            stats.addStats((String)entry.getKey(), (String)entry.getValue());
        }
        return stats;
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.assertRemoteCacheManagerIsStarted();
        if (trace) {
            log.tracef("About to add (K,V): (%s, %s) lifespan:%d, maxIdle:%d", key, value, lifespan, maxIdleTime);
        }
        PutOperation op = this.operationsFactory.newPutKeyValueOperation(this.compatKeyIfNeeded(key), this.obj2bytes(key, true), this.obj2bytes(value, false), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return (V)op.execute();
    }

    private K compatKeyIfNeeded(Object key) {
        return (K)(this.hasCompatibility ? key : null);
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.assertRemoteCacheManagerIsStarted();
        PutIfAbsentOperation op = this.operationsFactory.newPutIfAbsentOperation(this.compatKeyIfNeeded(key), this.obj2bytes(key, true), this.obj2bytes(value, false), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return (V)op.execute();
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.assertRemoteCacheManagerIsStarted();
        ReplaceOperation op = this.operationsFactory.newReplaceOperation(this.compatKeyIfNeeded(key), this.obj2bytes(key, true), this.obj2bytes(value, false), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return (V)op.execute();
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.assertRemoteCacheManagerIsStarted();
        int flags = this.operationsFactory.flags();
        return CompletableFuture.supplyAsync(() -> {
            if (flags != 0) {
                this.operationsFactory.setFlags(flags);
            }
            return this.put(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
        }, this.executorService);
    }

    @Override
    public CompletableFuture<Void> clearAsync() {
        this.assertRemoteCacheManagerIsStarted();
        return CompletableFuture.runAsync(this::clear, this.executorService);
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.assertRemoteCacheManagerIsStarted();
        int flags = this.operationsFactory.flags();
        return CompletableFuture.supplyAsync(() -> {
            if (flags != 0) {
                this.operationsFactory.setFlags(flags);
            }
            return this.putIfAbsent(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
        }, this.executorService);
    }

    @Override
    public CompletableFuture<V> removeAsync(Object key) {
        this.assertRemoteCacheManagerIsStarted();
        int flags = this.operationsFactory.flags();
        return CompletableFuture.supplyAsync(() -> {
            if (flags != 0) {
                this.operationsFactory.setFlags(flags);
            }
            return this.remove(key);
        }, this.executorService);
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.assertRemoteCacheManagerIsStarted();
        int flags = this.operationsFactory.flags();
        return CompletableFuture.supplyAsync(() -> {
            if (flags != 0) {
                this.operationsFactory.setFlags(flags);
            }
            return this.replace(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
        }, this.executorService);
    }

    @Override
    public boolean containsKey(Object key) {
        this.assertRemoteCacheManagerIsStarted();
        ContainsKeyOperation op = this.operationsFactory.newContainsKeyOperation(this.compatKeyIfNeeded(key), this.obj2bytes(key, true));
        return (Boolean)op.execute();
    }

    @Override
    public V get(Object key) {
        this.assertRemoteCacheManagerIsStarted();
        byte[] keyBytes = this.obj2bytes(key, true);
        GetOperation gco = this.operationsFactory.newGetKeyOperation(this.compatKeyIfNeeded(key), keyBytes);
        Object result = gco.execute();
        if (trace) {
            log.tracef("For key(%s) returning %s", key, result);
        }
        return (V)result;
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys) {
        this.assertRemoteCacheManagerIsStarted();
        if (trace) {
            log.tracef("About to getAll entries (%s)", (Object)keys);
        }
        HashSet<byte[]> byteKeys = new HashSet<byte[]>(keys.size());
        for (K key : keys) {
            byteKeys.add(this.obj2bytes(key, true));
        }
        GetAllParallelOperation op = this.operationsFactory.newGetAllOperation(byteKeys);
        Map result = (Map)op.execute();
        return Collections.unmodifiableMap(result);
    }

    @Override
    public Map<K, V> getBulk() {
        return this.getBulk(0);
    }

    @Override
    public Map<K, V> getBulk(int size) {
        this.assertRemoteCacheManagerIsStarted();
        BulkGetOperation op = this.operationsFactory.newBulkGetOperation(size);
        Map result = (Map)op.execute();
        return Collections.unmodifiableMap(result);
    }

    @Override
    public V remove(Object key) {
        this.assertRemoteCacheManagerIsStarted();
        RemoveOperation removeOperation = this.operationsFactory.newRemoveOperation(this.compatKeyIfNeeded(key), this.obj2bytes(key, true));
        return (V)removeOperation.execute();
    }

    @Override
    public void clear() {
        this.assertRemoteCacheManagerIsStarted();
        ClearOperation op = this.operationsFactory.newClearOperation();
        op.execute();
    }

    @Override
    public void start() {
        if (log.isDebugEnabled()) {
            log.debugf("Start called, nothing to do here(%s)", (Object)this.getName());
        }
    }

    @Override
    public void stop() {
        if (log.isDebugEnabled()) {
            log.debugf("Stop called, nothing to do here(%s)", (Object)this.getName());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return RemoteCacheImpl.class.getPackage().getImplementationVersion();
    }

    @Override
    public String getProtocolVersion() {
        return Version.getProtocolVersion();
    }

    @Override
    public void addClientListener(Object listener) {
        this.assertRemoteCacheManagerIsStarted();
        AddClientListenerOperation op = this.operationsFactory.newAddClientListenerOperation(listener);
        op.execute();
    }

    @Override
    public void addClientListener(Object listener, Object[] filterFactoryParams, Object[] converterFactoryParams) {
        this.assertRemoteCacheManagerIsStarted();
        byte[][] marshalledFilterParams = this.marshallParams(filterFactoryParams);
        byte[][] marshalledConverterParams = this.marshallParams(converterFactoryParams);
        AddClientListenerOperation op = this.operationsFactory.newAddClientListenerOperation(listener, marshalledFilterParams, marshalledConverterParams);
        op.execute();
    }

    private byte[][] marshallParams(Object[] params) {
        if (params == null) {
            return new byte[0][];
        }
        byte[][] marshalledParams = new byte[params.length][];
        for (int i = 0; i < marshalledParams.length; ++i) {
            byte[] bytes = this.obj2bytes(params[i], true);
            marshalledParams[i] = bytes;
        }
        return marshalledParams;
    }

    @Override
    public void removeClientListener(Object listener) {
        this.assertRemoteCacheManagerIsStarted();
        RemoveClientListenerOperation op = this.operationsFactory.newRemoveClientListenerOperation(listener);
        op.execute();
    }

    @Override
    public Set<Object> getListeners() {
        ClientListenerNotifier listenerNotifier = this.operationsFactory.getListenerNotifier();
        return listenerNotifier.getListeners(this.operationsFactory.getCacheName());
    }

    @Override
    public RemoteCache<K, V> withFlags(Flag ... flags) {
        this.operationsFactory.setFlags(flags);
        return this;
    }

    @Override
    public CompletableFuture<V> getAsync(K key) {
        this.assertRemoteCacheManagerIsStarted();
        return CompletableFuture.supplyAsync(() -> this.get(key), this.executorService);
    }

    public PingOperation.PingResult ping() {
        return (PingOperation.PingResult)((Object)this.operationsFactory.newFaultTolerantPingOperation().execute());
    }

    private byte[] obj2bytes(Object o, boolean isKey) {
        try {
            return this.marshaller.objectToByteBuffer(o, isKey ? this.estimateKeySize : this.estimateValueSize);
        }
        catch (IOException ioe) {
            throw new HotRodClientException("Unable to marshall object of type [" + o.getClass().getName() + "]", ioe);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private void assertRemoteCacheManagerIsStarted() {
        if (!this.remoteCacheManager.isStarted()) {
            String message = "Cannot perform operations on a cache associated with an unstarted RemoteCacheManager. Use RemoteCacheManager.start before using the remote cache.";
            if (log.isInfoEnabled()) {
                log.unstartedRemoteCacheManager();
            }
            throw new RemoteCacheManagerNotStartedException(message);
        }
    }

    @Override
    protected void set(K key, V value) {
        this.put(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public Set<K> keySet() {
        this.assertRemoteCacheManagerIsStarted();
        BulkGetKeysOperation op = this.operationsFactory.newBulkGetKeysOperation(0);
        return Collections.unmodifiableSet((Set)op.execute());
    }

    @Override
    public <T> T execute(String taskName, Map<String, ?> params) {
        this.assertRemoteCacheManagerIsStarted();
        HashMap<String, byte[]> marshalledParams = new HashMap<String, byte[]>();
        if (params != null) {
            for (Map.Entry<String, ?> entry : params.entrySet()) {
                marshalledParams.put(entry.getKey(), this.obj2bytes(entry.getValue(), false));
            }
        }
        ExecuteOperation op = this.operationsFactory.newExecuteOperation(taskName, marshalledParams);
        return op.execute();
    }

    @Override
    public CacheTopologyInfo getCacheTopologyInfo() {
        return this.operationsFactory.getCacheTopologyInfo();
    }

    public PingOperation.PingResult resolveCompatibility() {
        if (this.remoteCacheManager.isStarted()) {
            PingOperation.PingResult result = this.ping();
            this.hasCompatibility = result.hasCompatibility();
            return result;
        }
        return PingOperation.PingResult.FAIL;
    }

    private abstract class WithFlagsCallable
    implements Callable<V> {
        final int intFlags;

        protected WithFlagsCallable(int intFlags) {
            this.intFlags = intFlags;
        }

        void setFlagsIfPresent() {
            if (this.intFlags != 0) {
                RemoteCacheImpl.this.operationsFactory.setFlags(this.intFlags);
            }
        }
    }
}

