/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import infinispan.org.jboss.logging.Logger;
import org.infinispan.query.dsl.FilterConditionBeginContext;
import org.infinispan.query.dsl.FilterConditionContext;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.impl.AndCondition;
import org.infinispan.query.dsl.impl.BooleanCondition;
import org.infinispan.query.dsl.impl.IncompleteCondition;
import org.infinispan.query.dsl.impl.OrCondition;
import org.infinispan.query.dsl.impl.Visitable;
import org.infinispan.query.dsl.impl.logging.Log;

abstract class BaseCondition
implements FilterConditionContext,
Visitable {
    private static final Log log = Logger.getMessageLogger(Log.class, BaseCondition.class.getName());
    protected BaseCondition parent = null;
    protected QueryBuilder queryBuilder;
    protected final QueryFactory queryFactory;

    protected BaseCondition(QueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    @Override
    public QueryBuilder toBuilder() {
        if (this.queryBuilder == null) {
            throw log.subQueryDoesNotBelongToAParentQueryBuilder();
        }
        return this.queryBuilder;
    }

    void setQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder != null) {
            throw log.queryAlreadyBelongsToAnotherBuilder();
        }
        this.queryBuilder = queryBuilder;
    }

    public BaseCondition getRoot() {
        BaseCondition p = this;
        while (p.getParent() != null) {
            p = p.getParent();
        }
        return p;
    }

    public BaseCondition getParent() {
        return this.parent;
    }

    public void setParent(BaseCondition parent) {
        this.parent = parent;
    }

    @Override
    public FilterConditionBeginContext and() {
        IncompleteCondition rightCondition = new IncompleteCondition(this.queryFactory);
        this.combine(true, rightCondition);
        return rightCondition;
    }

    @Override
    public FilterConditionContext and(FilterConditionContext rightCondition) {
        this.combine(true, rightCondition);
        return this;
    }

    @Override
    public FilterConditionBeginContext or() {
        IncompleteCondition rightCondition = new IncompleteCondition(this.queryFactory);
        this.combine(false, rightCondition);
        return rightCondition;
    }

    @Override
    public FilterConditionContext or(FilterConditionContext rightCondition) {
        this.combine(false, rightCondition);
        return this;
    }

    private void combine(boolean isConjunction, FilterConditionContext fcc) {
        if (fcc == null) {
            throw log.argumentCannotBeNull();
        }
        BaseCondition rightCondition = ((BaseCondition)fcc).getRoot();
        if (rightCondition.queryFactory != this.queryFactory) {
            throw log.conditionWasCreatedByAnotherFactory();
        }
        if (rightCondition.queryBuilder != null) {
            throw log.conditionIsAlreadyInUseByAnotherBuilder();
        }
        if (isConjunction && this.parent instanceof OrCondition) {
            AndCondition p = new AndCondition(this.queryFactory, this, rightCondition);
            ((BooleanCondition)this.parent).replaceChildCondition(this, p);
            this.parent = p;
            rightCondition.setParent(p);
        } else {
            BaseCondition root = this.getRoot();
            BooleanCondition p = isConjunction ? new AndCondition(this.queryFactory, root, rightCondition) : new OrCondition(this.queryFactory, root, rightCondition);
            root.setParent(p);
            rightCondition.setParent(p);
        }
        rightCondition.setQueryBuilder(this.queryBuilder);
    }
}

