/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.operations.validation;

import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import infinispan.org.jboss.as.controller.operations.validation.MinMaxValidator;
import infinispan.org.jboss.as.controller.operations.validation.ParameterValidator;
import infinispan.org.jboss.dmr.ModelNode;
import java.util.List;

public class NillableOrExpressionParameterValidator
implements ParameterValidator,
MinMaxValidator,
AllowedValuesValidator {
    private final ParameterValidator delegate;
    private final Boolean allowNull;
    private final boolean allowExpression;

    public NillableOrExpressionParameterValidator(ParameterValidator delegate, Boolean allowNull, boolean allowExpression) {
        if (delegate == null) {
            throw ControllerLogger.ROOT_LOGGER.nullVar("delegate");
        }
        this.delegate = delegate;
        this.allowNull = allowNull;
        this.allowExpression = allowExpression;
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        switch (value.getType()) {
            case EXPRESSION: {
                if (this.allowExpression) break;
                throw ControllerLogger.ROOT_LOGGER.expressionNotAllowed(parameterName);
            }
            case UNDEFINED: {
                if (this.allowNull != null) {
                    if (this.allowNull.booleanValue()) break;
                    throw ControllerLogger.ROOT_LOGGER.nullNotAllowed(parameterName);
                }
            }
            default: {
                this.delegate.validateParameter(parameterName, value);
            }
        }
    }

    @Override
    public void validateResolvedParameter(String parameterName, ModelNode value) throws OperationFailedException {
        switch (value.getType()) {
            case EXPRESSION: {
                if (this.allowExpression) break;
                throw ControllerLogger.ROOT_LOGGER.expressionNotAllowed(parameterName);
            }
            case UNDEFINED: {
                if (this.allowNull != null) {
                    if (this.allowNull.booleanValue()) break;
                    throw ControllerLogger.ROOT_LOGGER.nullNotAllowed(parameterName);
                }
            }
            default: {
                this.delegate.validateResolvedParameter(parameterName, value);
            }
        }
    }

    @Override
    public Long getMin() {
        return this.delegate instanceof MinMaxValidator ? ((MinMaxValidator)((Object)this.delegate)).getMin() : null;
    }

    @Override
    public Long getMax() {
        return this.delegate instanceof MinMaxValidator ? ((MinMaxValidator)((Object)this.delegate)).getMax() : null;
    }

    public ParameterValidator getDelegate() {
        return this.delegate;
    }

    public Boolean getAllowNull() {
        return this.allowNull;
    }

    public boolean isAllowExpression() {
        return this.allowExpression;
    }

    @Override
    public List<ModelNode> getAllowedValues() {
        return this.delegate instanceof AllowedValuesValidator ? ((AllowedValuesValidator)((Object)this.delegate)).getAllowedValues() : null;
    }
}

