/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import java.util.Properties;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.spi.CachingProvider;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.jcache.AbstractJCache;
import org.infinispan.jcache.AbstractJCacheManager;
import org.infinispan.jcache.logging.Log;
import org.infinispan.jcache.remote.ConfigurationAdapter;
import org.infinispan.jcache.remote.JCache;
import org.infinispan.jcache.remote.RemoteCacheAccess;

public class JCacheManager
extends AbstractJCacheManager {
    private static final Log log = LogFactory.getLog(JCacheManager.class, Log.class);
    private RemoteCacheManager cm;
    private RemoteCacheManager cmForceReturnValue;
    private RemoteCacheAccess cacheAccess;

    public JCacheManager(URI uri, ClassLoader classLoader, CachingProvider provider, Properties properties) {
        super(uri, classLoader, provider, properties, false);
        ConfigurationBuilder builder = this.getConfigurationBuilder(properties);
        Configuration configuration = builder.build();
        this.cm = new RemoteCacheManager(configuration, true);
        builder.forceReturnValues(true);
        this.cmForceReturnValue = new RemoteCacheManager(builder.build(), true);
        this.cacheAccess = RemoteCacheAccess.createCacheAccess(this.cm, properties);
    }

    private ConfigurationBuilder getConfigurationBuilder(Properties userProperties) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        if (userProperties != null && !userProperties.isEmpty()) {
            this.properties = userProperties;
            builder.withProperties(userProperties);
        } else {
            InputStream is = this.findPropertiesFile();
            if (is != null) {
                Properties fileProperties = new Properties();
                try {
                    fileProperties.load(is);
                    this.properties = fileProperties;
                    builder.withProperties(fileProperties);
                }
                catch (IOException e) {
                    throw new CacheException("Unable to load properties from `hotrod-client.properties`", (Throwable)e);
                }
            } else {
                builder.addServer().host("127.0.0.1").port(11222);
            }
        }
        return builder;
    }

    private InputStream findPropertiesFile() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return FileLookupFactory.newInstance().lookupFile("hotrod-client.properties", cl);
    }

    public ClassLoader getClassLoader() {
        return this.cm.getConfiguration().classLoader();
    }

    @Override
    protected <K, V, C extends javax.cache.configuration.Configuration<K, V>> AbstractJCache<K, V> create(String cacheName, C configuration) {
        ConfigurationAdapter adapter = ConfigurationAdapter.create(configuration);
        this.cacheAccess.addCacheIfAbsent(cacheName);
        return this.createJCache(cacheName, adapter);
    }

    private <K, V> AbstractJCache<K, V> createJCache(String cacheName, ConfigurationAdapter<K, V> adapter) {
        RemoteCache<K, V> ispnCache = this.getRemoteCache(this.cm, cacheName);
        RemoteCache<K, V> ispnCacheForceReturnValue = this.getRemoteCache(this.cmForceReturnValue, cacheName);
        return new JCache<K, V>(ispnCache, ispnCacheForceReturnValue, this, adapter);
    }

    private <K, V> RemoteCache<K, V> getRemoteCache(RemoteCacheManager cm, String cacheName) {
        BasicCache ispnCache = cm.getCache(cacheName);
        if (ispnCache == null) {
            throw log.cacheNotFound(cacheName);
        }
        return ispnCache;
    }

    @Override
    public <K, V> Cache<K, V> getCache(String cacheName) {
        Cache cache = super.getCache(cacheName);
        return Objects.isNull(cache) ? this.createRegisterJCache(cacheName) : cache;
    }

    public <K, V> Cache<K, V> createRegisterJCache(String cacheName) {
        BasicCache ispnCache = this.cm.getCache(cacheName);
        BasicCache ispnCacheForceReturnValue = this.cmForceReturnValue.getCache(cacheName);
        if (ispnCache != null && this.cmForceReturnValue != null) {
            ConfigurationAdapter adapter = ConfigurationAdapter.create();
            JCache jcache = new JCache(ispnCache, ispnCacheForceReturnValue, this, adapter);
            this.registerPredefinedCache(cacheName, jcache);
            return jcache;
        }
        return null;
    }

    @Override
    public <K, V> Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        Cache<K, V> cache = super.getCache(cacheName, keyType, valueType);
        return Objects.isNull(cache) ? this.createRegisterJCache(cacheName) : cache;
    }

    @Override
    protected <K, V, I extends BasicCache<K, V>> AbstractJCache<K, V> create(I ispnCache) {
        return null;
    }

    public <T> T unwrap(Class<T> clazz) {
        return ReflectionUtil.unwrap(this, clazz);
    }

    @Override
    protected Iterable<String> delegateCacheNames() {
        return this.getManagedCacheNames();
    }

    @Override
    protected void delegateStop() {
        this.cm.stop();
        this.cmForceReturnValue.stop();
    }

    @Override
    protected boolean delegateIsClosed() {
        return false;
    }

    @Override
    protected <K, V> void delegateRemoveCache(AbstractJCache<K, V> jcache) {
        this.cacheAccess.removeCache(jcache.getName());
        jcache.close();
    }

    @Override
    protected void delegateLogIsClosed() {
        throw log.cacheClosed();
    }
}

