/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.remote;

import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.client.ModelControllerClient;
import infinispan.org.jboss.dmr.ModelNode;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.jcache.remote.logging.Log;

interface RemoteCacheAccess {
    public static final String MANAGED_ACCESS = "infinispan.jcache.remote.managed_access";

    public void addCacheIfAbsent(String var1);

    public void removeCache(String var1);

    public static RemoteCacheAccess createCacheAccess(RemoteCacheContainer rm, Properties p) {
        TypedProperties tp = new TypedProperties(p);
        boolean managedAccess = tp.getBooleanProperty(MANAGED_ACCESS, true);
        return managedAccess ? new ManagedAccess(rm.getConfiguration().servers().get(0).host(), 9990) : new UnmanagedAccess(rm);
    }

    public static final class UnmanagedAccess
    implements RemoteCacheAccess {
        static final Log log = LogFactory.getLog(UnmanagedAccess.class, Log.class);
        private final RemoteCacheContainer rm;

        UnmanagedAccess(RemoteCacheContainer rm) {
            this.rm = rm;
        }

        @Override
        public void addCacheIfAbsent(String cacheName) {
            if (this.rm.getCache(cacheName) != null) {
                throw log.cacheNamePredefined(cacheName);
            }
            throw log.createCacheNotAllowedWithoutManagement();
        }

        @Override
        public void removeCache(String cacheName) {
            throw log.removeCacheNotAllowedWithoutManagement();
        }
    }

    public static final class ManagedAccess
    implements RemoteCacheAccess {
        private static final Log log = LogFactory.getLog(ManagedAccess.class, Log.class);
        private static final String INFINISPAN_SUBSYSTEM_NAME = "datagrid-infinispan";
        private static final String INFINISPAN_ENDPOINT_SUBSYSTEM_NAME = "datagrid-infinispan-endpoint";
        private final String host;
        private final int port;

        ManagedAccess(String host, int port) {
            this.host = host;
            this.port = port;
        }

        private void checkExistence(final String cacheType, final String cacheName, final AtomicBoolean result) throws ManagementClientException {
            if (!result.get()) {
                ManagedAccess.withManagementClient(this.host, this.port, new ManagementRunnable(){

                    @Override
                    public void run(ModelControllerClient client) throws Exception {
                        PathAddress pathAddress = PathAddress.pathAddress("subsystem", ManagedAccess.INFINISPAN_SUBSYSTEM_NAME).append("cache-container", this.getHotRodCacheContainer(client)).append(cacheType, cacheName);
                        ModelNode op = new ModelNode();
                        op.get("operation").set("read-attribute");
                        op.get("address").set(pathAddress.toModelNode());
                        op.get("name").set("configuration");
                        ModelNode resp = client.execute(op);
                        if ("success".equals(resp.get("outcome").asString())) {
                            result.set(true);
                        }
                    }
                });
            }
        }

        private boolean containsCache(String cacheName) throws NotAvailableException, ManagementClientException {
            ManagedAccess.checkServerManagementAvailable();
            AtomicBoolean result = new AtomicBoolean(false);
            this.checkExistence("local-cache", cacheName, result);
            this.checkExistence("distributed-cache", cacheName, result);
            this.checkExistence("replicated-cache", cacheName, result);
            this.checkExistence("invalidation-cache", cacheName, result);
            return result.get();
        }

        private void addCache(final String cacheName) throws NotAvailableException, ManagementClientException {
            ManagedAccess.checkServerManagementAvailable();
            ManagedAccess.withManagementClient(this.host, this.port, new ManagementRunnable(){

                @Override
                public void run(ModelControllerClient client) throws Exception {
                    ModelNode composite = new ModelNode();
                    composite.get("operation").set("composite");
                    composite.get("address").setEmptyList();
                    ModelNode steps = composite.get("steps");
                    ModelNode configAddOp = steps.add();
                    configAddOp.get("operation").set("add");
                    String cacheContainer = this.getHotRodCacheContainer(client);
                    configAddOp.get("address").set(PathAddress.pathAddress("subsystem", ManagedAccess.INFINISPAN_SUBSYSTEM_NAME).append("cache-container", cacheContainer).append("configurations", "CONFIGURATIONS").append("local-cache-configuration", cacheName).toModelNode());
                    configAddOp.get("template").set(false);
                    ModelNode cacheAddOp = steps.add();
                    cacheAddOp.get("operation").set("add");
                    cacheAddOp.get("address").set(PathAddress.pathAddress("subsystem", ManagedAccess.INFINISPAN_SUBSYSTEM_NAME).append("cache-container", cacheContainer).append("local-cache", cacheName).toModelNode());
                    cacheAddOp.get("configuration").set(cacheName);
                    ModelNode resp = client.execute(composite);
                    if (!"success".equals(resp.get("outcome").asString())) {
                        System.err.println(resp);
                        throw new IllegalArgumentException(resp.asString());
                    }
                }
            });
        }

        @Override
        public void addCacheIfAbsent(String cacheName) {
            try {
                if (!this.containsCache(cacheName)) {
                    this.addCache(cacheName);
                }
            }
            catch (NotAvailableException notAvailableException) {
            }
            catch (ManagementClientException ex) {
                throw log.cacheCreationFailed(cacheName, ex);
            }
        }

        @Override
        public void removeCache(final String cacheName) {
            try {
                ManagedAccess.checkServerManagementAvailable();
                ManagedAccess.withManagementClient(this.host, this.port, new ManagementRunnable(){

                    @Override
                    public void run(ModelControllerClient client) throws Exception {
                        ModelNode composite = new ModelNode();
                        composite.get("operation").set("composite");
                        composite.get("address").setEmptyList();
                        ModelNode steps = composite.get("steps");
                        ModelNode cacheRemoveOp = steps.add();
                        cacheRemoveOp.get("operation").set("remove");
                        String cacheContainer = this.getHotRodCacheContainer(client);
                        cacheRemoveOp.get("address").set(PathAddress.pathAddress("subsystem", ManagedAccess.INFINISPAN_SUBSYSTEM_NAME).append("cache-container", cacheContainer).append("local-cache", cacheName).toModelNode());
                        ModelNode configRemoveOp = steps.add();
                        configRemoveOp.get("operation").set("remove");
                        configRemoveOp.get("address").set(PathAddress.pathAddress("subsystem", ManagedAccess.INFINISPAN_SUBSYSTEM_NAME).append("cache-container", cacheContainer).append("configurations", "CONFIGURATIONS").append("local-cache-configuration", cacheName).toModelNode());
                        ModelNode resp = client.execute(composite);
                        if (!"success".equals(resp.get("outcome").asString())) {
                            System.err.println(resp);
                        }
                    }
                });
            }
            catch (NotAvailableException notAvailableException) {
            }
            catch (ManagementClientException ex) {
                throw log.serverManagementOperationFailed(ex);
            }
        }

        private String getHotRodCacheContainer(ModelControllerClient client) throws IOException {
            PathAddress pathAddress = PathAddress.pathAddress("subsystem", INFINISPAN_ENDPOINT_SUBSYSTEM_NAME).append("hotrod-connector", "hotrod-connector");
            ModelNode op = new ModelNode();
            op.get("operation").set("read-attribute");
            op.get("address").set(pathAddress.toModelNode());
            op.get("name").set("cache-container");
            ModelNode resp = client.execute(op);
            if (!"success".equals(resp.get("outcome").asString())) {
                throw new IllegalArgumentException(resp.asString());
            }
            return resp.get("result").asString();
        }

        private static void withManagementClient(String host, int port, ManagementRunnable runnable) throws ManagementClientException {
            InetAddress addr;
            try {
                addr = InetAddress.getByName(host);
            }
            catch (UnknownHostException ex) {
                throw new ManagementClientException(String.format("Failed to resolve host '%s'.", host), ex);
            }
            ModelControllerClient client = ModelControllerClient.Factory.create("http-remoting", addr, port);
            try {
                runnable.run(client);
            }
            catch (Exception ex) {
                throw new ManagementClientException("", ex);
            }
            finally {
                try {
                    client.close();
                }
                catch (IOException iOException) {}
            }
        }

        private static void checkServerManagementAvailable() throws NotAvailableException {
            try {
                boolean skipServerMgmtLookup = Boolean.parseBoolean(System.getProperty("infinispan.jcache.mgmt.lookup.skip", "false"));
                if (skipServerMgmtLookup) {
                    throw new NotAvailableException();
                }
                Class.forName("infinispan.org.jboss.as.controller.client.ModelControllerClient");
            }
            catch (ClassNotFoundException e) {
                throw new NotAvailableException();
            }
        }

        public static class ManagementClientException
        extends Exception {
            private static final long serialVersionUID = -5857650491476258495L;

            public ManagementClientException() {
            }

            public ManagementClientException(String message, Throwable cause) {
                super(message, cause);
            }
        }

        public static class NotAvailableException
        extends Exception {
            private static final long serialVersionUID = 2036495722939416728L;

            public NotAvailableException() {
            }

            public NotAvailableException(String message, Throwable cause) {
                super(message, cause);
            }
        }

        private static interface ManagementRunnable {
            public void run(ModelControllerClient var1) throws Exception;
        }
    }
}

