/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryExp;

final class SecurityActions {
    SecurityActions() {
    }

    static void registerMBean(Object mbean, ObjectName objectName, MBeanServer mBeanServer) throws Exception {
        AccessController.doPrivileged(() -> {
            try {
                mBeanServer.registerMBean(mbean, objectName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        });
    }

    static void unregisterMBean(ObjectName objectName, MBeanServer mBeanServer) throws Exception {
        AccessController.doPrivileged(() -> {
            try {
                mBeanServer.unregisterMBean(objectName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        });
    }

    static Set<ObjectName> queryNames(ObjectName target, QueryExp query, MBeanServer mBeanServer) {
        HashSet<ObjectName> results = new HashSet<ObjectName>();
        try {
            return AccessController.doPrivileged(() -> {
                results.addAll(mBeanServer.queryNames(target, query));
                return results;
            });
        }
        catch (Exception e) {
            return results;
        }
    }
}

