/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import infinispan.org.jboss.logging.Logger;
import org.infinispan.query.dsl.impl.logging.Log;

final class ValueRange {
    private static final Log log = Logger.getMessageLogger(Log.class, ValueRange.class.getName());
    private final Object from;
    private final Object to;
    private boolean includeLower = true;
    private boolean includeUpper = true;

    public ValueRange(Object from, Object to) {
        if (!(from instanceof Comparable)) {
            throw log.argumentMustBeComparable("from");
        }
        if (!(to instanceof Comparable)) {
            throw log.argumentMustBeComparable("to");
        }
        this.from = from;
        this.to = to;
    }

    public Object getFrom() {
        return this.from;
    }

    public Object getTo() {
        return this.to;
    }

    public boolean isIncludeLower() {
        return this.includeLower;
    }

    public void setIncludeLower(boolean includeLower) {
        this.includeLower = includeLower;
    }

    public boolean isIncludeUpper() {
        return this.includeUpper;
    }

    public void setIncludeUpper(boolean includeUpper) {
        this.includeUpper = includeUpper;
    }

    public String toString() {
        return (this.includeLower ? "[" : "(") + this.from + ", " + this.to + (this.includeUpper ? "]" : ")");
    }
}

