package org.infinispan.client.hotrod.event;

/**
 * The events generated by default contain just enough information to make the
 * event relevant but they avoid cramming too much information in order to reduce
 * the cost of sending them. Optionally, the information shipped in the events
 * can be customised in order to contain more information, such as values, or to
 * contain even less information. This customization is done with {@link org.infinispan.filter.Converter}
 * instances generated by a {@link org.infinispan.filter.ConverterFactory}.
 *
 * As a result of this conversion, custom events are reprenseted by this class,
 * and are expected in methods annotation with either
 * {@link org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated},
 * {@link org.infinispan.client.hotrod.annotation.ClientCacheEntryModified} or,
 * {@link org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved}.
 * The event parameter for any of these callbacks is always a {@link ClientCacheEntryCustomEvent},
 * and if needed, the event's {@link org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent#getType()}
 * can be queried to find out whether the originating event was the result of create,
 * modified or removed.
 *
 * @param <T> Type of customized event data. It needs to be marshallable.
 */
public interface ClientCacheEntryCustomEvent<T> extends ClientEvent {

   /**
    * Customized event data. It can be any type as long as it can be converted
    * to binary format for shipping between the server and client.
    *
    * @return an instance of the customised event data.
    */
   T getEventData();

   /**
    * This will be true if the write command that caused this had to be retried
    * again due to a topology change.  This could be a sign that this event
    * has been duplicated or another event was dropped and replaced
    * (eg: ModifiedEvent replaced CreateEvent)
    *
    * @return Whether the command that caused this event was retried
    */
   boolean isCommandRetried();

}
