/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.descriptions;

import infinispan.org.jboss.as.controller.AttributeDefinition;
import infinispan.org.jboss.as.controller.DeprecationData;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.PathElement;
import infinispan.org.jboss.as.controller.access.management.AccessConstraintDescriptionProviderUtil;
import infinispan.org.jboss.as.controller.capability.Capability;
import infinispan.org.jboss.as.controller.capability.RuntimeCapability;
import infinispan.org.jboss.as.controller.descriptions.DescriptionProvider;
import infinispan.org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import infinispan.org.jboss.as.controller.registry.AttributeAccess;
import infinispan.org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import infinispan.org.jboss.dmr.ModelNode;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;

public class DefaultResourceDescriptionProvider
implements DescriptionProvider {
    private final ImmutableManagementResourceRegistration registration;
    private final ResourceDescriptionResolver descriptionResolver;
    private final DeprecationData deprecationData;

    public DefaultResourceDescriptionProvider(ImmutableManagementResourceRegistration registration, ResourceDescriptionResolver descriptionResolver) {
        this(registration, descriptionResolver, null);
    }

    public DefaultResourceDescriptionProvider(ImmutableManagementResourceRegistration registration, ResourceDescriptionResolver descriptionResolver, DeprecationData deprecationData) {
        this.registration = registration;
        this.descriptionResolver = descriptionResolver;
        this.deprecationData = deprecationData;
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        ModelNode result = new ModelNode();
        ResourceBundle bundle2 = this.descriptionResolver.getResourceBundle(locale);
        result.get("description").set(this.descriptionResolver.getResourceDescription(locale, bundle2));
        int minOccurs = this.registration.getMinOccurs();
        if (minOccurs > 0) {
            result.get("min-occurs").set(minOccurs);
        }
        int maxOccurs = this.registration.getMaxOccurs();
        PathAddress pa = this.registration.getPathAddress();
        if (pa == null || pa.size() == 0) {
            result.get("max-occurs").set(maxOccurs);
        } else {
            int defaultMax;
            int n = defaultMax = pa.getLastElement().isWildcard() ? Integer.MAX_VALUE : 1;
            if (maxOccurs != defaultMax) {
                result.get("max-occurs").set(maxOccurs);
            }
        }
        Set<RuntimeCapability> capabilities = this.registration.getCapabilities();
        if (capabilities != null && !capabilities.isEmpty()) {
            for (Capability capability : capabilities) {
                ModelNode cap = result.get("capabilities").add();
                cap.get("name").set(capability.getName());
                cap.get("dynamic").set(capability.isDynamicallyNamed());
            }
        }
        if (this.deprecationData != null) {
            ModelNode deprecated = this.addDeprecatedInfo(result);
            deprecated.get("reason").set(this.descriptionResolver.getResourceDeprecatedDescription(locale, bundle2));
        }
        if (this.registration.isRuntimeOnly()) {
            result.get("storage").set("runtime-only");
        }
        AccessConstraintDescriptionProviderUtil.addAccessConstraints(result, this.registration.getAccessConstraints(), locale);
        Set<String> attributeNames = this.registration.getAttributeNames(PathAddress.EMPTY_ADDRESS);
        TreeMap<AttributeDefinition.NameAndGroup, ModelNode> treeMap = new TreeMap<AttributeDefinition.NameAndGroup, ModelNode>();
        for (String string : attributeNames) {
            AttributeAccess attributeAccess = this.registration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, string);
            AttributeDefinition def = attributeAccess.getAttributeDefinition();
            if (def != null) {
                ModelNode attrDesc = new ModelNode();
                def.addResourceAttributeDescription(attrDesc, this.descriptionResolver, locale, bundle2);
                treeMap.put(new AttributeDefinition.NameAndGroup(def), attrDesc.get("attributes", string));
                continue;
            }
            treeMap.put(new AttributeDefinition.NameAndGroup(string), new ModelNode());
        }
        ModelNode attributes = result.get("attributes").setEmptyObject();
        for (Map.Entry entry : treeMap.entrySet()) {
            attributes.get(((AttributeDefinition.NameAndGroup)entry.getKey()).getName()).set((ModelNode)entry.getValue());
        }
        result.get("operations");
        result.get("notifications");
        ModelNode modelNode = result.get("children").setEmptyObject();
        Set<PathElement> set = this.registration.getChildAddresses(PathAddress.EMPTY_ADDRESS);
        HashSet<String> childTypes = new HashSet<String>();
        for (PathElement childAddress : set) {
            String key = childAddress.getKey();
            if (!childTypes.add(key)) continue;
            ModelNode childNode = modelNode.get(key);
            childNode.get("description").set(this.descriptionResolver.getChildTypeDescription(key, locale, bundle2));
            childNode.get("model-description");
        }
        return result;
    }

    private ModelNode addDeprecatedInfo(ModelNode model) {
        ModelNode deprecated = model.get("deprecated");
        deprecated.get("since").set(this.deprecationData.getSince().toString());
        deprecated.get("reason");
        return deprecated;
    }
}

