/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.extension;

import infinispan.org.jboss.as.controller.Extension;
import infinispan.org.jboss.as.controller.OperationContext;
import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.OperationStepHandler;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.extension.ExtensionRegistry;
import infinispan.org.jboss.as.controller.extension.ExtensionRegistryType;
import infinispan.org.jboss.as.controller.extension.ExtensionResource;
import infinispan.org.jboss.as.controller.extension.MutableRootResourceRegistrationProvider;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.registry.ManagementResourceRegistration;
import infinispan.org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleNotFoundException;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ExtensionAddHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "add";
    private final ExtensionRegistry extensionRegistry;
    private final boolean parallelBoot;
    private final ExtensionRegistryType extensionRegistryType;
    private final MutableRootResourceRegistrationProvider rootResourceRegistrationProvider;

    public ExtensionAddHandler(ExtensionRegistry extensionRegistry, boolean parallelBoot, ExtensionRegistryType extensionRegistryType, MutableRootResourceRegistrationProvider rootResourceRegistrationProvider) {
        assert (extensionRegistry != null) : "extensionRegistry is null";
        this.extensionRegistry = extensionRegistry;
        this.parallelBoot = parallelBoot;
        this.extensionRegistryType = extensionRegistryType;
        this.rootResourceRegistrationProvider = rootResourceRegistrationProvider;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ManagementResourceRegistration rootRegistration;
        boolean install;
        final String moduleName = context.getCurrentAddressValue();
        final ExtensionResource resource = new ExtensionResource(moduleName, this.extensionRegistry);
        context.addResource(PathAddress.EMPTY_ADDRESS, resource);
        boolean bl = install = !this.parallelBoot || !context.isBooting();
        if (install) {
            rootRegistration = this.rootResourceRegistrationProvider.getRootResourceRegistrationForUpdate(context);
            ExtensionAddHandler.initializeExtension(this.extensionRegistry, moduleName, rootRegistration, this.extensionRegistryType);
            if (this.extensionRegistryType == ExtensionRegistryType.SLAVE && !context.isBooting()) {
                ModelNode subsystems = new ModelNode();
                this.extensionRegistry.recordSubsystemVersions(moduleName, subsystems);
                context.getResult().set(subsystems);
            }
        } else {
            rootRegistration = null;
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            @Override
            public void handleRollback(OperationContext context, ModelNode operation) {
                if (install) {
                    ExtensionAddHandler.this.extensionRegistry.removeExtension(resource, moduleName, rootRegistration);
                }
            }
        });
    }

    void initializeExtension(String module, ManagementResourceRegistration rootRegistration) {
        ExtensionAddHandler.initializeExtension(this.extensionRegistry, module, rootRegistration, this.extensionRegistryType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initializeExtension(ExtensionRegistry extensionRegistry, String module, ManagementResourceRegistration rootRegistration, ExtensionRegistryType extensionRegistryType) {
        try {
            boolean unknownModule = false;
            for (Extension extension : Module.loadServiceFromCallerModuleLoader(ModuleIdentifier.fromString(module), Extension.class)) {
                ClassLoader oldTccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(extension.getClass());
                try {
                    if (unknownModule || !extensionRegistry.getExtensionModuleNames().contains(module)) {
                        extension.initializeParsers(extensionRegistry.getExtensionParsingContext(module, null));
                        unknownModule = true;
                    }
                    extension.initialize(extensionRegistry.getExtensionContext(module, rootRegistration, extensionRegistryType));
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(oldTccl);
                }
            }
        }
        catch (ModuleNotFoundException e) {
            throw ControllerLogger.ROOT_LOGGER.extensionModuleNotFound(e, module);
        }
        catch (ModuleLoadException e) {
            throw ControllerLogger.ROOT_LOGGER.extensionModuleLoadingFailure(e, module);
        }
    }
}

