/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.operations.global;

import infinispan.org.jboss.as.controller.AttributeDefinition;
import infinispan.org.jboss.as.controller.OperationContext;
import infinispan.org.jboss.as.controller.OperationDefinition;
import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.OperationStepHandler;
import infinispan.org.jboss.as.controller.SimpleAttributeDefinition;
import infinispan.org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import infinispan.org.jboss.as.controller.descriptions.common.ControllerResolver;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.operations.global.AbstractCollectionHandler;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class ListOperations {
    public static final OperationDefinition LIST_ADD_DEFINITION = new SimpleOperationDefinitionBuilder("list-add", ControllerResolver.getResolver("global")).setParameters(AbstractCollectionHandler.NAME, AbstractCollectionHandler.VALUE, AbstractListHandler.INDEX).setRuntimeOnly().build();
    public static final OperationDefinition LIST_GET_DEFINITION = new SimpleOperationDefinitionBuilder("list-get", ControllerResolver.getResolver("global")).setParameters(AbstractCollectionHandler.NAME, AbstractListHandler.INDEX).setRuntimeOnly().setReadOnly().build();
    public static final OperationDefinition LIST_REMOVE_DEFINITION = new SimpleOperationDefinitionBuilder("list-remove", ControllerResolver.getResolver("global")).setParameters(AbstractCollectionHandler.NAME, AbstractCollectionHandler.VALUE, AbstractListHandler.INDEX).setRuntimeOnly().build();
    public static final OperationDefinition LIST_CLEAR_DEFINITION = new SimpleOperationDefinitionBuilder("list-clear", ControllerResolver.getResolver("global")).setParameters(AbstractCollectionHandler.NAME).setRuntimeOnly().build();
    public static final OperationStepHandler LIST_ADD_HANDLER = new ListAddHandler();
    public static final OperationStepHandler LIST_REMOVE_HANDLER = new ListRemoveHandler();
    public static final OperationStepHandler LIST_GET_HANDLER = new ListGetHandler();
    public static final OperationStepHandler LIST_CLEAR_HANDLER = new ListClearHandler();
    public static final Set<String> LIST_OPERATION_NAMES = new HashSet<String>(Arrays.asList(LIST_CLEAR_DEFINITION.getName(), LIST_REMOVE_DEFINITION.getName(), LIST_ADD_DEFINITION.getName(), LIST_GET_DEFINITION.getName()));

    public static class ListClearHandler
    extends AbstractListHandler {
        private ListClearHandler() {
            super(new AttributeDefinition[0]);
        }

        @Override
        void updateModel(OperationContext context, ModelNode model, ModelNode listAttribute) throws OperationFailedException {
            listAttribute.setEmptyList();
        }
    }

    public static class ListGetHandler
    extends AbstractListHandler {
        private ListGetHandler() {
            super(false, INDEX);
        }

        @Override
        void updateModel(OperationContext context, ModelNode model, ModelNode listAttribute) throws OperationFailedException {
            int index = INDEX.resolveModelAttribute(context, model).asInt();
            if (listAttribute.hasDefined(index)) {
                context.getResult().set(listAttribute.get(index));
            }
        }
    }

    public static class ListRemoveHandler
    extends AbstractListHandler {
        private ListRemoveHandler() {
            super(VALUE, INDEX);
        }

        @Override
        void updateModel(OperationContext context, ModelNode model, ModelNode listAttribute) throws OperationFailedException {
            ModelNode value = model.get(VALUE.getName());
            ModelNode index = INDEX.resolveModelAttribute(context, model);
            ArrayList<ModelNode> res = new ArrayList<ModelNode>(listAttribute.asList());
            if (index.isDefined()) {
                res.remove(index.asInt());
            } else {
                res.remove(value);
            }
            listAttribute.set(res);
        }
    }

    public static class ListAddHandler
    extends AbstractListHandler {
        private ListAddHandler() {
            super(VALUE, INDEX);
        }

        @Override
        void updateModel(OperationContext context, ModelNode model, ModelNode listAttribute) throws OperationFailedException {
            ModelNode value = model.get(VALUE.getName());
            ModelNode indexNode = INDEX.resolveModelAttribute(context, model);
            LinkedList<ModelNode> res = new LinkedList<ModelNode>(listAttribute.isDefined() ? listAttribute.asList() : Collections.emptyList());
            if (indexNode.isDefined()) {
                res.add(indexNode.asInt(), value);
            } else {
                res.add(value);
            }
            listAttribute.set(res);
        }
    }

    static abstract class AbstractListHandler
    extends AbstractCollectionHandler {
        static final SimpleAttributeDefinition INDEX = new SimpleAttributeDefinition("index", ModelType.INT, true);

        AbstractListHandler(AttributeDefinition ... attributes) {
            super(attributes);
        }

        AbstractListHandler(boolean requiredReadWrite, AttributeDefinition ... attributes) {
            super(requiredReadWrite, attributes);
        }

        @Override
        public void updateModel(OperationContext context, ModelNode model, AttributeDefinition attributeDefinition, ModelNode attribute) throws OperationFailedException {
            if (attribute.getType() != ModelType.LIST && attributeDefinition.getType() != ModelType.LIST) {
                throw ControllerLogger.MGMT_OP_LOGGER.attributeIsWrongType(attributeDefinition.getName(), ModelType.LIST, attributeDefinition.getType());
            }
            this.updateModel(context, model, attribute);
        }

        abstract void updateModel(OperationContext var1, ModelNode var2, ModelNode var3) throws OperationFailedException;
    }
}

