/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import org.infinispan.client.hotrod.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.configuration.Builder;

public class NearCacheConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<NearCacheConfiguration> {
    private static final Log log = LogFactory.getLog(NearCacheConfigurationBuilder.class);
    private NearCacheMode mode = NearCacheMode.DISABLED;
    private Integer maxEntries = null;

    protected NearCacheConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public NearCacheConfigurationBuilder maxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
        return this;
    }

    public NearCacheConfigurationBuilder mode(NearCacheMode mode) {
        this.mode = mode;
        return this;
    }

    @Override
    public void validate() {
        if (this.mode.enabled() && this.maxEntries == null) {
            throw log.nearCacheMaxEntriesUndefined();
        }
    }

    @Override
    public NearCacheConfiguration create() {
        return new NearCacheConfiguration(this.mode, this.maxEntries == null ? -1 : this.maxEntries);
    }

    @Override
    public Builder<?> read(NearCacheConfiguration template) {
        this.mode = template.mode();
        this.maxEntries = template.maxEntries();
        return this;
    }
}

