/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.impl.ProtoSchemaGenerator;
import org.infinispan.protostream.config.Configuration;
import protostream.org.apache.commons.cli.CommandLine;
import protostream.org.apache.commons.cli.GnuParser;
import protostream.org.apache.commons.cli.HelpFormatter;
import protostream.org.apache.commons.cli.Option;
import protostream.org.apache.commons.cli.Options;

public final class ProtoSchemaBuilder {
    public static final String FILE_OPT = "f";
    public static final String FILE_LONG_OPT = "file";
    public static final String PACKAGE_OPT = "p";
    public static final String PACKAGE_LONG_OPT = "package";
    public static final String HELP_OPT = "h";
    public static final String HELP_LONG_OPT = "help";
    public static final String MARSHALLER_OPT = "m";
    public static final String MARSHALLER_LONG_OPT = "marshaller";
    public static final String SCHEMA_OPT = "s";
    public static final String SCHEMA_LONG_OPT = "schema";
    public static boolean generateSchemaDebugComments = false;
    private String fileName;
    private String packageName;
    private final Set<Class<?>> classes = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String[] marshallers;
        Option f = new Option(FILE_OPT, FILE_LONG_OPT, true, "output file name");
        Option p = new Option(PACKAGE_OPT, PACKAGE_LONG_OPT, true, "Protobuf package name");
        p.setRequired(true);
        Option h = new Option(HELP_OPT, HELP_LONG_OPT, false, "Print usage information");
        Option m = new Option(MARSHALLER_OPT, MARSHALLER_LONG_OPT, true, "Register custom marshaller class");
        Option s = new Option(SCHEMA_OPT, SCHEMA_LONG_OPT, true, "Register Protobuf schema");
        s.setArgs(2);
        s.setValueSeparator('=');
        Options options = new Options();
        options.addOption(f);
        options.addOption(p);
        options.addOption(h);
        options.addOption(m);
        options.addOption(s);
        GnuParser parser = new GnuParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption(HELP_OPT)) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java " + ProtoSchemaBuilder.class.getName(), "Arguments: ", options, "followed by a list of class names to process");
            return;
        }
        String packageName = cmd.getOptionValue(PACKAGE_LONG_OPT);
        Configuration config = Configuration.builder().build();
        SerializationContext ctx = ProtobufUtil.newSerializationContext(config);
        Properties schemas = cmd.getOptionProperties(SCHEMA_LONG_OPT);
        if (schemas != null) {
            for (String string : schemas.stringPropertyNames()) {
                String file = schemas.getProperty(string);
                try (FileInputStream in = null;){
                    in = new FileInputStream(file);
                    ctx.registerProtoFiles(new FileDescriptorSource().addProtoFile(string, in));
                }
            }
        }
        if ((marshallers = cmd.getOptionValues(MARSHALLER_LONG_OPT)) != null) {
            for (String string : marshallers) {
                BaseMarshaller bm = (BaseMarshaller)Class.forName(string).newInstance();
                ctx.registerMarshaller(bm);
            }
        }
        File file = cmd.hasOption(FILE_LONG_OPT) ? new File(cmd.getOptionValue(FILE_LONG_OPT)) : null;
        String fileName = file == null ? "generated.proto" : file.getName();
        ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder().fileName(fileName).packageName(packageName);
        for (String className : cmd.getArgs()) {
            protoSchemaBuilder.addClass(Class.forName(className));
        }
        String string = protoSchemaBuilder.build(ctx);
        if (file != null) {
            try (PrintStream out = new PrintStream(new FileOutputStream(file));){
                out.print(string);
            }
        } else {
            System.out.print(string);
        }
    }

    public ProtoSchemaBuilder fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public ProtoSchemaBuilder packageName(String packageName) {
        if (packageName.trim().isEmpty()) {
            throw new IllegalArgumentException("packageName cannot be empty");
        }
        this.packageName = packageName;
        return this;
    }

    public ProtoSchemaBuilder addClass(Class<?> clazz) {
        this.classes.add(clazz);
        return this;
    }

    public String build(SerializationContext serializationContext) throws ProtoSchemaBuilderException, IOException {
        if (this.fileName == null) {
            throw new ProtoSchemaBuilderException("fileName cannot be null");
        }
        if (this.classes.isEmpty()) {
            throw new ProtoSchemaBuilderException("At least one class must be specified");
        }
        String schema = new ProtoSchemaGenerator(serializationContext, this.fileName, this.packageName, this.classes).generateAndRegister();
        this.fileName = null;
        this.packageName = null;
        this.classes.clear();
        return schema;
    }
}

