/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller;

import infinispan.org.jboss.as.controller.OperationContext;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.capability.RuntimeCapability;

public interface CapabilityReferenceRecorder {
    public void addCapabilityRequirements(OperationContext var1, String var2, String ... var3);

    public void removeCapabilityRequirements(OperationContext var1, String var2, String ... var3);

    public String getBaseDependentName();

    public String getBaseRequirementName();

    public boolean isDynamicDependent();

    public static class DefaultCapabilityReferenceRecorder
    implements CapabilityReferenceRecorder {
        private final String baseRequirementName;
        private final String baseDependentName;
        private final boolean dynamicDependent;

        public DefaultCapabilityReferenceRecorder(String baseRequirementName, String baseDependentName, boolean dynamicDependent) {
            this.baseRequirementName = baseRequirementName;
            this.baseDependentName = baseDependentName;
            this.dynamicDependent = dynamicDependent;
        }

        @Override
        public final void addCapabilityRequirements(OperationContext context, String attributeName, String ... attributeValues) {
            this.processCapabilityRequirement(context, attributeName, false, attributeValues);
        }

        @Override
        public final void removeCapabilityRequirements(OperationContext context, String attributeName, String ... attributeValues) {
            this.processCapabilityRequirement(context, attributeName, true, attributeValues);
        }

        private void processCapabilityRequirement(OperationContext context, String attributeName, boolean remove, String ... attributeValues) {
            String dependentName = this.dynamicDependent ? RuntimeCapability.buildDynamicCapabilityName(this.baseDependentName, this.getDynamicDependentName(context.getCurrentAddress())) : this.baseDependentName;
            for (String attributeValue : attributeValues) {
                if (attributeValue == null) continue;
                String requirementName = RuntimeCapability.buildDynamicCapabilityName(this.baseRequirementName, attributeValue);
                if (remove) {
                    context.deregisterCapabilityRequirement(requirementName, dependentName);
                    continue;
                }
                context.registerAdditionalCapabilityRequirement(requirementName, dependentName, attributeName);
            }
        }

        protected String getDynamicDependentName(PathAddress currentAddress) {
            return currentAddress.getLastElement().getValue();
        }

        @Override
        public String getBaseDependentName() {
            return this.baseDependentName;
        }

        @Override
        public String getBaseRequirementName() {
            return this.baseRequirementName;
        }

        @Override
        public boolean isDynamicDependent() {
            return this.dynamicDependent;
        }
    }
}

