/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller;

import infinispan.org.jboss.as.controller.ControlledProcessStateService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicStampedReference;

public class ControlledProcessState {
    private final AtomicInteger stamp = new AtomicInteger(0);
    private final AtomicStampedReference<State> state = new AtomicStampedReference<State>(State.STARTING, 0);
    private final boolean reloadSupported;
    private final ControlledProcessStateService service;
    private boolean restartRequiredFlag = false;

    public ControlledProcessState(boolean reloadSupported) {
        this.reloadSupported = reloadSupported;
        this.service = new ControlledProcessStateService(State.STARTING);
    }

    public State getState() {
        return this.state.getReference();
    }

    public boolean isReloadSupported() {
        return this.reloadSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStarting() {
        ControlledProcessStateService controlledProcessStateService = this.service;
        synchronized (controlledProcessStateService) {
            this.state.set(State.STARTING, this.stamp.incrementAndGet());
            this.service.stateChanged(State.STARTING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning() {
        State was;
        AtomicStampedReference<State> stateRef = this.state;
        int newStamp = this.stamp.incrementAndGet();
        int[] receiver = new int[1];
        while ((was = stateRef.get(receiver)) == State.STARTING) {
            ControlledProcessStateService controlledProcessStateService = this.service;
            synchronized (controlledProcessStateService) {
                State newState;
                State state = newState = this.restartRequiredFlag ? State.RESTART_REQUIRED : State.RUNNING;
                if (this.state.compareAndSet(was, newState, receiver[0], newStamp)) {
                    this.service.stateChanged(newState);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStopping() {
        ControlledProcessStateService controlledProcessStateService = this.service;
        synchronized (controlledProcessStateService) {
            this.state.set(State.STOPPING, this.stamp.incrementAndGet());
            this.service.stateChanged(State.STOPPING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setReloadRequired() {
        State was;
        if (!this.reloadSupported) {
            return this.setRestartRequired();
        }
        AtomicStampedReference<State> stateRef = this.state;
        int newStamp = this.stamp.incrementAndGet();
        int[] receiver = new int[1];
        while ((was = stateRef.get(receiver)) != State.STARTING && was != State.STOPPING && was != State.RESTART_REQUIRED) {
            ControlledProcessStateService controlledProcessStateService = this.service;
            synchronized (controlledProcessStateService) {
                if (stateRef.compareAndSet(was, State.RELOAD_REQUIRED, receiver[0], newStamp)) {
                    this.service.stateChanged(State.RELOAD_REQUIRED);
                    break;
                }
            }
        }
        return newStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setRestartRequired() {
        State was;
        AtomicStampedReference<State> stateRef = this.state;
        int newStamp = this.stamp.incrementAndGet();
        int[] receiver = new int[1];
        while ((was = stateRef.get(receiver)) != State.STARTING && was != State.STOPPING) {
            ControlledProcessStateService controlledProcessStateService = this.service;
            synchronized (controlledProcessStateService) {
                if (stateRef.compareAndSet(was, State.RESTART_REQUIRED, receiver[0], newStamp)) {
                    this.restartRequiredFlag = true;
                    this.service.stateChanged(State.RESTART_REQUIRED);
                    break;
                }
            }
        }
        return newStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revertReloadRequired(Object stamp) {
        if (!this.reloadSupported) {
            this.revertRestartRequired(stamp);
        }
        Integer theirStamp = (Integer)Integer.class.cast(stamp);
        ControlledProcessStateService controlledProcessStateService = this.service;
        synchronized (controlledProcessStateService) {
            if (this.state.compareAndSet(State.RELOAD_REQUIRED, State.RUNNING, theirStamp, this.stamp.incrementAndGet())) {
                this.service.stateChanged(State.RUNNING);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revertRestartRequired(Object stamp) {
        Integer theirStamp = (Integer)Integer.class.cast(stamp);
        ControlledProcessStateService controlledProcessStateService = this.service;
        synchronized (controlledProcessStateService) {
            if (this.state.compareAndSet(State.RESTART_REQUIRED, State.RUNNING, theirStamp, this.stamp.incrementAndGet())) {
                this.restartRequiredFlag = false;
                this.service.stateChanged(State.RUNNING);
            }
        }
    }

    ControlledProcessStateService getService() {
        return this.service;
    }

    public static enum State {
        STARTING("starting"),
        RUNNING("running"),
        RELOAD_REQUIRED("reload-required"),
        RESTART_REQUIRED("restart-required"),
        STOPPING("stopping");

        private final String stringForm;

        private State(String stringForm) {
            this.stringForm = stringForm;
        }

        public String toString() {
            return this.stringForm;
        }
    }
}

