/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.protocol.mgmt;

import infinispan.org.jboss.as.protocol.StreamUtils;
import infinispan.org.jboss.as.protocol.logging.ProtocolLogger;
import infinispan.org.jboss.as.protocol.mgmt.FlushableDataOutput;
import infinispan.org.jboss.as.protocol.mgmt.FlushableDataOutputImpl;
import infinispan.org.jboss.as.protocol.mgmt.ManagementRequestContext;
import infinispan.org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ProtocolUtils {
    public static FlushableDataOutput wrapAsDataOutput(OutputStream os) {
        return FlushableDataOutputImpl.create(os);
    }

    public static <A> ManagementRequestContext.AsyncTask<A> emptyResponseTask() {
        return new ManagementRequestContext.AsyncTask<A>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(ManagementRequestContext<A> context) throws Exception {
                ManagementResponseHeader header = ManagementResponseHeader.create(context.getRequestHeader());
                FlushableDataOutput output = context.writeMessage(header);
                try {
                    output.writeByte(36);
                    output.close();
                }
                finally {
                    StreamUtils.safeClose(output);
                }
            }
        };
    }

    public static <A> void writeResponse(ResponseWriter writer, ManagementRequestContext<A> context) throws IOException {
        ManagementResponseHeader header = ManagementResponseHeader.create(context.getRequestHeader());
        ProtocolUtils.writeResponse(writer, context, header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A> void writeResponse(ResponseWriter writer, ManagementRequestContext<A> context, ManagementResponseHeader header) throws IOException {
        FlushableDataOutput output = context.writeMessage(header);
        try {
            writer.write(output);
            output.writeByte(36);
            output.close();
        }
        finally {
            StreamUtils.safeClose(output);
        }
    }

    public static void expectHeader(InputStream input, int expected) throws IOException {
        ProtocolUtils.expectHeader(ProtocolUtils.readByte(input), expected);
    }

    public static void expectHeader(DataInput input, int expected) throws IOException {
        ProtocolUtils.expectHeader(input.readByte(), expected);
    }

    public static void expectHeader(byte actual, int expected) throws IOException {
        if (actual != (byte)expected) {
            throw ProtocolLogger.ROOT_LOGGER.invalidByteToken(expected, actual);
        }
    }

    public static int readInt(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static void writeInt(OutputStream out, int v) throws IOException {
        out.write(v >>> 24 & 0xFF);
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 0 & 0xFF);
    }

    public static byte readByte(InputStream stream) throws IOException {
        int b = stream.read();
        if (b == -1) {
            throw new EOFException();
        }
        return (byte)b;
    }

    public static interface ResponseWriter {
        public static final ResponseWriter EMPTY = new ResponseWriter(){

            @Override
            public void write(FlushableDataOutput output) throws IOException {
            }
        };

        public void write(FlushableDataOutput var1) throws IOException;
    }
}

