/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.operations.common;

import infinispan.org.jboss.as.controller.ExpressionResolver;
import infinispan.org.jboss.as.controller.OperationContext;
import infinispan.org.jboss.as.controller.OperationDefinition;
import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.OperationStepHandler;
import infinispan.org.jboss.as.controller.SimpleAttributeDefinition;
import infinispan.org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import infinispan.org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import infinispan.org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import infinispan.org.jboss.as.controller.descriptions.common.ControllerResolver;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.parsing.ParseUtils;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;

public class ResolveExpressionHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "resolve-expression";
    public static final ResolveExpressionHandler INSTANCE = new ResolveExpressionHandler();
    public static final SimpleAttributeDefinition EXPRESSION = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("expression", ModelType.STRING, true).setAllowExpression(true)).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("resolve-expression", ControllerResolver.getResolver("core")).addParameter(EXPRESSION).setReplyType(ModelType.STRING).allowReturnNull().setReadOnly().setRuntimeOnly().addAccessConstraint(SensitiveTargetAccessConstraintDefinition.SYSTEM_PROPERTY).build();

    private ResolveExpressionHandler() {
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode toResolve = EXPRESSION.validateOperation(operation);
                if (toResolve.getType() == ModelType.STRING) {
                    toResolve = ParseUtils.parsePossibleExpression(toResolve.asString());
                }
                try {
                    ModelNode resolved = ExpressionResolver.SIMPLE.resolveExpressions(toResolve);
                    ModelNode result = context.getResult();
                    if (resolved.isDefined()) {
                        result.set(resolved.asString());
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
                catch (SecurityException e) {
                    throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noPermissionToResolveExpression(toResolve, e));
                }
                catch (IllegalStateException e) {
                    ModelNode failureDescription = ControllerLogger.ROOT_LOGGER.cannotResolveExpression(toResolve.asString()).getFailureDescription();
                    this.deferFailureReporting(context, failureDescription);
                }
                catch (OperationFailedException e) {
                    this.deferFailureReporting(context, e.getFailureDescription());
                }
            }

            private void deferFailureReporting(OperationContext context, final ModelNode failureDescription) {
                if (context.isRollbackOnRuntimeFailure()) {
                    context.setRollbackOnly();
                }
                context.completeStep(new OperationContext.ResultHandler(){

                    @Override
                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        context.getFailureDescription().set(failureDescription);
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

