/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller;

import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartException;

public final class ContainerStateMonitor
extends AbstractServiceListener<Object> {
    private final ServiceRegistry serviceRegistry;
    private final StabilityMonitor monitor = new StabilityMonitor();
    final Set<ServiceController<?>> failed = new HashSet();
    final Set<ServiceController<?>> problems = new HashSet();
    private Set<ServiceName> previousMissingDepSet = new HashSet<ServiceName>();

    ContainerStateMonitor(ServiceRegistry registry) {
        this.serviceRegistry = registry;
    }

    void logContainerStateChangesAndReset() {
        ContainerStateChangeReport changeReport = this.createContainerStateChangeReport(true);
        if (changeReport != null) {
            String msg = this.createChangeReportLogMessage(changeReport);
            ControllerLogger.ROOT_LOGGER.info(msg);
        }
    }

    @Override
    public void listenerAdded(ServiceController<?> controller) {
        this.monitor.addController(controller);
        controller.removeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitStabilityUninterruptibly(long timeout, TimeUnit timeUnit) throws TimeoutException {
        boolean interrupted = false;
        try {
            long toWait = timeUnit.toMillis(timeout);
            long msTimeout = System.currentTimeMillis() + toWait;
            while (true) {
                if (interrupted) {
                    toWait = msTimeout - System.currentTimeMillis();
                }
                try {
                    if (toWait <= 0L || !this.monitor.awaitStability(toWait, TimeUnit.MILLISECONDS, this.failed, this.problems)) {
                        throw new TimeoutException();
                    }
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    void awaitStability(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        if (!this.monitor.awaitStability(timeout, timeUnit, this.failed, this.problems)) {
            throw new TimeoutException();
        }
    }

    ContainerStateChangeReport awaitContainerStateChangeReport(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        if (this.monitor.awaitStability(timeout, timeUnit, this.failed, this.problems)) {
            return this.createContainerStateChangeReport(false);
        }
        throw new TimeoutException();
    }

    /*
     * WARNING - void declaration
     */
    private synchronized ContainerStateChangeReport createContainerStateChangeReport(boolean resetHistory) {
        HashMap missingDeps = new HashMap();
        for (ServiceController<?> controller : this.problems) {
            for (ServiceName serviceName : controller.getImmediateUnavailableDependencies()) {
                void var7_11;
                Set set = (Set)missingDeps.get(serviceName);
                if (set == null) {
                    HashSet hashSet = new HashSet();
                    missingDeps.put(serviceName, hashSet);
                }
                var7_11.add(controller.getName());
            }
        }
        Set<ServiceName> previousMissing = this.previousMissingDepSet;
        TreeMap<ServiceName, Boolean> noLongerMissingServices = new TreeMap<ServiceName, Boolean>();
        for (ServiceName serviceName : previousMissing) {
            if (missingDeps.containsKey(serviceName)) continue;
            ServiceController<?> serviceController = this.serviceRegistry.getService(serviceName);
            noLongerMissingServices.put(serviceName, serviceController != null);
        }
        TreeMap<ServiceName, MissingDependencyInfo> missingServices = new TreeMap<ServiceName, MissingDependencyInfo>();
        for (Map.Entry entry : missingDeps.entrySet()) {
            ServiceName name = (ServiceName)entry.getKey();
            if (previousMissing.contains(name)) continue;
            ServiceController<?> controller = this.serviceRegistry.getService(name);
            boolean unavailable = controller != null;
            missingServices.put(name, new MissingDependencyInfo(name, unavailable, (Set)entry.getValue()));
        }
        HashSet hashSet = new HashSet(this.failed);
        if (resetHistory) {
            this.previousMissingDepSet = new HashSet(missingDeps.keySet());
            this.failed.clear();
            this.problems.clear();
        }
        boolean bl = !missingServices.isEmpty() || !hashSet.isEmpty() || !noLongerMissingServices.isEmpty();
        return bl ? new ContainerStateChangeReport(missingServices, hashSet, noLongerMissingServices) : null;
    }

    private synchronized String createChangeReportLogMessage(ContainerStateChangeReport changeReport) {
        StringBuilder msg = new StringBuilder();
        msg.append(ControllerLogger.ROOT_LOGGER.serviceStatusReportHeader());
        if (!changeReport.getMissingServices().isEmpty()) {
            msg.append(ControllerLogger.ROOT_LOGGER.serviceStatusReportDependencies());
            for (Map.Entry<ServiceName, MissingDependencyInfo> entry : changeReport.getMissingServices().entrySet()) {
                if (!entry.getValue().isUnavailable()) {
                    msg.append(ControllerLogger.ROOT_LOGGER.serviceStatusReportMissing(entry.getKey(), ContainerStateMonitor.createDependentsString(entry.getValue().getDependents())));
                    continue;
                }
                msg.append(ControllerLogger.ROOT_LOGGER.serviceStatusReportUnavailable(entry.getKey(), ContainerStateMonitor.createDependentsString(entry.getValue().getDependents())));
            }
        }
        if (!changeReport.getNoLongerMissingServices().isEmpty()) {
            msg.append(ControllerLogger.ROOT_LOGGER.serviceStatusReportCorrected());
            for (Map.Entry entry : changeReport.getNoLongerMissingServices().entrySet()) {
                if (((Boolean)entry.getValue()).booleanValue()) {
                    msg.append(ControllerLogger.ROOT_LOGGER.serviceStatusReportAvailable((ServiceName)entry.getKey()));
                    continue;
                }
                msg.append(ControllerLogger.ROOT_LOGGER.serviceStatusReportNoLongerRequired((ServiceName)entry.getKey()));
            }
        }
        if (!changeReport.getFailedControllers().isEmpty()) {
            msg.append(ControllerLogger.ROOT_LOGGER.serviceStatusReportFailed());
            for (ServiceController serviceController : changeReport.getFailedControllers()) {
                msg.append("      ").append(serviceController.getName());
                StartException startException = serviceController.getStartException();
                if (startException != null) {
                    msg.append(": ").append(startException.toString());
                }
                msg.append('\n');
            }
        }
        return msg.toString();
    }

    private static String createDependentsString(Set<ServiceName> serviceNames) {
        if (serviceNames.size() <= 4) {
            return serviceNames.toString();
        }
        StringBuilder ret = new StringBuilder("[");
        Iterator<ServiceName> it = serviceNames.iterator();
        for (int count = 0; count < 4; ++count) {
            ServiceName val = it.next();
            ret.append(val);
            ret.append(", ");
        }
        ret.append(ControllerLogger.ROOT_LOGGER.andNMore(serviceNames.size() - 3));
        ret.append(" ]");
        return ret.toString();
    }

    public static class MissingDependencyInfo {
        private final ServiceName serviceName;
        private final boolean unavailable;
        private final Set<ServiceName> dependents;

        public MissingDependencyInfo(ServiceName serviceName, boolean unavailable, Set<ServiceName> dependents) {
            this.serviceName = serviceName;
            this.unavailable = unavailable;
            this.dependents = dependents;
        }

        public ServiceName getServiceName() {
            return this.serviceName;
        }

        public boolean isUnavailable() {
            return this.unavailable;
        }

        public Set<ServiceName> getDependents() {
            return Collections.unmodifiableSet(this.dependents);
        }
    }

    public static class ContainerStateChangeReport {
        private final Map<ServiceName, MissingDependencyInfo> missingServices;
        private final Set<ServiceController<?>> failedControllers;
        private final Map<ServiceName, Boolean> noLongerMissingServices;

        private ContainerStateChangeReport(Map<ServiceName, MissingDependencyInfo> missingServices, Set<ServiceController<?>> failedControllers, Map<ServiceName, Boolean> noLongerMissingServices) {
            this.missingServices = missingServices;
            this.failedControllers = failedControllers;
            this.noLongerMissingServices = noLongerMissingServices;
        }

        public final Set<ServiceController<?>> getFailedControllers() {
            return this.failedControllers;
        }

        public Map<ServiceName, MissingDependencyInfo> getMissingServices() {
            return this.missingServices;
        }

        public Map<ServiceName, Boolean> getNoLongerMissingServices() {
            return this.noLongerMissingServices;
        }
    }
}

