/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.util.Properties;
import org.infinispan.client.hotrod.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ConnectionPoolConfiguration;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.infinispan.client.hotrod.impl.TypedProperties;
import org.infinispan.commons.configuration.Builder;

public class ConnectionPoolConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<ConnectionPoolConfiguration> {
    private ExhaustedAction exhaustedAction = ExhaustedAction.WAIT;
    private boolean lifo = true;
    private int maxActive = -1;
    private int maxTotal = -1;
    private long maxWait = -1L;
    private int maxIdle = -1;
    private int minIdle = 1;
    private long timeBetweenEvictionRuns = 120000L;
    private long minEvictableIdleTime = 1800000L;
    private int numTestsPerEvictionRun = 3;
    private boolean testOnBorrow = false;
    private boolean testOnReturn = false;
    private boolean testWhileIdle = true;

    ConnectionPoolConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public ConnectionPoolConfigurationBuilder exhaustedAction(ExhaustedAction exhaustedAction) {
        this.exhaustedAction = exhaustedAction;
        return this;
    }

    public ConnectionPoolConfigurationBuilder lifo(boolean enabled) {
        this.lifo = enabled;
        return this;
    }

    public ConnectionPoolConfigurationBuilder maxActive(int maxActive) {
        this.maxActive = maxActive;
        return this;
    }

    public ConnectionPoolConfigurationBuilder maxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
        return this;
    }

    public ConnectionPoolConfigurationBuilder maxWait(long maxWait) {
        this.maxWait = maxWait;
        return this;
    }

    public ConnectionPoolConfigurationBuilder maxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
        return this;
    }

    public ConnectionPoolConfigurationBuilder minIdle(int minIdle) {
        this.minIdle = minIdle;
        return this;
    }

    public ConnectionPoolConfigurationBuilder numTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
        return this;
    }

    public ConnectionPoolConfigurationBuilder timeBetweenEvictionRuns(long timeBetweenEvictionRuns) {
        this.timeBetweenEvictionRuns = timeBetweenEvictionRuns;
        return this;
    }

    public ConnectionPoolConfigurationBuilder minEvictableIdleTime(long minEvictableIdleTime) {
        this.minEvictableIdleTime = minEvictableIdleTime;
        return this;
    }

    public ConnectionPoolConfigurationBuilder testOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
        return this;
    }

    public ConnectionPoolConfigurationBuilder testOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
        return this;
    }

    public ConnectionPoolConfigurationBuilder testWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
        return this;
    }

    public ConnectionPoolConfigurationBuilder withPoolProperties(Properties properties) {
        TypedProperties typed = TypedProperties.toTypedProperties(properties);
        this.exhaustedAction(ExhaustedAction.values()[typed.getIntProperty("whenExhaustedAction", this.exhaustedAction.ordinal(), true)]);
        this.lifo(typed.getBooleanProperty("lifo", this.lifo, true));
        this.maxActive(typed.getIntProperty("maxActive", this.maxActive, true));
        this.maxTotal(typed.getIntProperty("maxTotal", this.maxTotal, true));
        this.maxWait(typed.getLongProperty("maxWait", this.maxWait, true));
        this.maxIdle(typed.getIntProperty("maxIdle", this.maxIdle, true));
        this.minIdle(typed.getIntProperty("minIdle", this.minIdle, true));
        this.numTestsPerEvictionRun(typed.getIntProperty("numTestsPerEvictionRun", this.numTestsPerEvictionRun, true));
        this.timeBetweenEvictionRuns(typed.getLongProperty("timeBetweenEvictionRunsMillis", this.timeBetweenEvictionRuns, true));
        this.minEvictableIdleTime(typed.getLongProperty("minEvictableIdleTimeMillis", this.minEvictableIdleTime, true));
        this.testOnBorrow(typed.getBooleanProperty("testOnBorrow", this.testOnBorrow, true));
        this.testOnReturn(typed.getBooleanProperty("testOnReturn", this.testOnReturn, true));
        this.testWhileIdle(typed.getBooleanProperty("testWhileIdle", this.testWhileIdle, true));
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public ConnectionPoolConfiguration create() {
        return new ConnectionPoolConfiguration(this.exhaustedAction, this.lifo, this.maxActive, this.maxTotal, this.maxWait, this.maxIdle, this.minIdle, this.numTestsPerEvictionRun, this.timeBetweenEvictionRuns, this.minEvictableIdleTime, this.testOnBorrow, this.testOnReturn, this.testWhileIdle);
    }

    public ConnectionPoolConfigurationBuilder read(ConnectionPoolConfiguration template) {
        this.exhaustedAction = template.exhaustedAction();
        this.lifo = template.lifo();
        this.maxActive = template.maxActive();
        this.maxTotal = template.maxTotal();
        this.maxWait = template.maxWait();
        this.maxIdle = template.maxIdle();
        this.minIdle = template.minIdle();
        this.numTestsPerEvictionRun = template.numTestsPerEvictionRun();
        this.timeBetweenEvictionRuns = template.timeBetweenEvictionRuns();
        this.minEvictableIdleTime = template.minEvictableIdleTime();
        this.testOnBorrow = template.testOnBorrow();
        this.testOnReturn = template.testOnReturn();
        this.testWhileIdle = template.testWhileIdle();
        return this;
    }
}

