/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.operations.validation;

import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.operations.validation.ModelTypeValidator;
import infinispan.org.jboss.as.controller.operations.validation.ParameterValidator;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;

public class PropertyValidator
extends ModelTypeValidator {
    private final ParameterValidator valueValidator;

    public PropertyValidator(boolean nullable, ParameterValidator valueValidator) {
        super(ModelType.PROPERTY, nullable);
        this.valueValidator = valueValidator;
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined()) {
            if (value.asProperty().getName().length() < 1) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidMinLength(value.asProperty().getName(), parameterName, 1));
            }
            if (this.valueValidator != null) {
                this.valueValidator.validateParameter(parameterName, value.asProperty().getValue());
            }
        }
    }
}

