/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller;

import infinispan.org.jboss.as.controller.AttributeDefinition;
import infinispan.org.jboss.as.controller.OperationStepHandler;
import infinispan.org.jboss.as.controller.registry.AttributeAccess;
import infinispan.org.jboss.as.controller.registry.ManagementResourceRegistration;

final class AttributeBinding {
    private final AttributeDefinition attribute;
    private final OperationStepHandler readOp;
    private final OperationStepHandler writeOp;
    private final AttributeAccess.AccessType accessType;

    AttributeBinding(AttributeDefinition attribute, OperationStepHandler readOp, OperationStepHandler writeOp, AttributeAccess.AccessType accessType) {
        this.attribute = attribute;
        this.readOp = readOp;
        this.writeOp = writeOp;
        this.accessType = accessType;
    }

    void register(ManagementResourceRegistration registration) {
        if (this.accessType == AttributeAccess.AccessType.READ_ONLY) {
            registration.registerReadOnlyAttribute(this.attribute, this.readOp);
        } else if (this.accessType == AttributeAccess.AccessType.READ_WRITE) {
            registration.registerReadWriteAttribute(this.attribute, this.readOp, this.writeOp);
        } else if (this.accessType == AttributeAccess.AccessType.METRIC) {
            registration.registerMetric(this.attribute, this.readOp);
        }
    }
}

