/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.operations.common;

import infinispan.org.jboss.as.controller.OperationDefinition;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.PathElement;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;
import java.util.Set;

public class Util {
    private Util() {
    }

    public static String getNameFromAddress(ModelNode address) {
        PathElement pe = PathAddress.pathAddress(address).getLastElement();
        return pe == null ? null : pe.getValue();
    }

    public static String getNameFromAddress(PathAddress address) {
        PathElement pe = PathAddress.pathAddress(address, new PathElement[0]).getLastElement();
        return pe == null ? null : pe.getValue();
    }

    public static ModelNode createAddOperation(PathAddress address) {
        return Util.createOperation("add", address);
    }

    public static ModelNode createAddOperation() {
        return Util.createEmptyOperation("add", null);
    }

    public static ModelNode createRemoveOperation(PathAddress address) {
        return Util.createOperation("remove", address);
    }

    public static ModelNode createOperation(String operationName, PathAddress address) {
        return Util.createEmptyOperation(operationName, address);
    }

    public static ModelNode createOperation(OperationDefinition operationDefinition, PathAddress address) {
        return Util.getEmptyOperation(operationDefinition.getName(), address.toModelNode());
    }

    public static ModelNode createEmptyOperation(String operationName, PathAddress address) {
        ModelNode op = new ModelNode();
        op.get("operation").set(operationName);
        if (address != null) {
            op.get("address").set(address.toModelNode());
        } else {
            op.get("address");
        }
        return op;
    }

    public static ModelNode getEmptyOperation(String operationName, ModelNode address) {
        return Util.createEmptyOperation(operationName, address == null ? null : PathAddress.pathAddress(address));
    }

    public static ModelNode getResourceRemoveOperation(PathAddress address) {
        return Util.createEmptyOperation("remove", address);
    }

    public static ModelNode getWriteAttributeOperation(ModelNode address, String attributeName, String value) {
        return Util.getWriteAttributeOperation(address, attributeName, new ModelNode().set(value));
    }

    public static ModelNode getWriteAttributeOperation(PathAddress address, String attributeName, int value) {
        return Util.getWriteAttributeOperation(address, attributeName, new ModelNode().set(value));
    }

    public static ModelNode getWriteAttributeOperation(PathAddress address, String attributeName, boolean value) {
        return Util.getWriteAttributeOperation(address, attributeName, new ModelNode().set(value));
    }

    public static ModelNode getWriteAttributeOperation(ModelNode address, String attributeName, ModelNode value) {
        return Util.getWriteAttributeOperation(PathAddress.pathAddress(address), attributeName, value);
    }

    public static ModelNode getWriteAttributeOperation(PathAddress address, String attributeName, String value) {
        return Util.getWriteAttributeOperation(address, attributeName, new ModelNode().set(value));
    }

    public static ModelNode getWriteAttributeOperation(PathAddress address, String attributeName, ModelNode value) {
        ModelNode op = Util.createEmptyOperation("write-attribute", address);
        op.get("name").set(attributeName);
        op.get("value").set(value);
        return op;
    }

    public static ModelNode getReadAttributeOperation(PathAddress address, String attributeName) {
        ModelNode op = Util.createEmptyOperation("read-attribute", address);
        op.get("name").set(attributeName);
        return op;
    }

    public static ModelNode getUndefineAttributeOperation(PathAddress address, String attributeName) {
        ModelNode op = Util.createEmptyOperation("undefine-attribute", address);
        op.get("name").set(attributeName);
        return op;
    }

    public static boolean isExpression(String value) {
        return value != null && value.startsWith("${") && value.endsWith("}");
    }

    public static ModelNode getOperation(String operationName, PathAddress address, ModelNode params) {
        ModelNode op = Util.createEmptyOperation(operationName, address);
        Set<String> keys = params.keys();
        keys.remove("operation");
        keys.remove("address");
        for (String key : keys) {
            op.get(key).set(params.get(key));
        }
        return op;
    }

    public static ModelNode getOperation(String operationName, ModelNode address, ModelNode params) {
        return Util.getOperation(operationName, PathAddress.pathAddress(address), params);
    }

    public static PathAddress getParentAddressByKey(PathAddress address, String parentKey) {
        for (int i = address.size() - 1; i >= 0; --i) {
            PathElement pe = address.getElement(i);
            if (!parentKey.equals(pe.getKey())) continue;
            return address.subAddress(0, i + 1);
        }
        return null;
    }

    public static ModelNode validateOperation(ModelNode operation) {
        ModelNode responseNode = new ModelNode();
        StringBuilder errors = new StringBuilder();
        if (!operation.hasDefined("operation") || operation.get("operation").asString() == null || operation.get("operation").asString().isEmpty()) {
            errors.append(ControllerLogger.ROOT_LOGGER.noOperationDefined(operation));
        }
        if (operation.hasDefined("address")) {
            try {
                if (operation.get("address").getType() == ModelType.STRING) {
                    ModelNode address = PathAddress.parseCLIStyleAddress(operation.get("address").asString()).toModelNode();
                    operation.get("address").set(address);
                } else {
                    operation.get("address").asList();
                }
            }
            catch (IllegalArgumentException ex) {
                if (errors.length() > 0) {
                    errors.append(System.lineSeparator());
                }
                if (ex.getMessage() != null) {
                    errors.append(ex.getMessage());
                }
                errors.append(ControllerLogger.ROOT_LOGGER.attributeIsWrongType("address", ModelType.LIST, operation.get("address").getType()).getMessage());
            }
        }
        if (errors.length() > 0) {
            responseNode.get("outcome").set("failed");
            responseNode.get("failure-description").set(errors.toString());
        }
        return responseNode;
    }
}

