/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.remote;

import java.util.concurrent.atomic.LongAdder;
import javax.cache.management.CacheStatisticsMXBean;

public class LocalStatistics
implements CacheStatisticsMXBean {
    private LongAdder cacheHits = new LongAdder();
    private LongAdder cacheMisses = new LongAdder();
    private LongAdder cacheGets = new LongAdder();
    private LongAdder cachePuts = new LongAdder();
    private LongAdder cacheRemovals = new LongAdder();
    private LongAdder cacheEvictions = new LongAdder();
    private float averageGetTime;
    private float averagePutTime;
    private float averageRemoveTime;

    public void incrementCacheHits() {
        this.cacheHits.add(1L);
    }

    public void incrementCacheMisses() {
        this.cacheMisses.add(1L);
    }

    public void incrementCacheGets() {
        this.cacheGets.add(1L);
    }

    public void incrementCachePuts() {
        this.cachePuts.add(1L);
    }

    public void incrementCacheRemovals() {
        this.cacheRemovals.add(1L);
    }

    public void incrementCacheEvictions() {
        this.cacheEvictions.add(1L);
    }

    public void clear() {
        this.cacheHits.reset();
        this.cacheMisses.reset();
        this.cacheGets.reset();
        this.cachePuts.reset();
        this.cacheRemovals.reset();
        this.cacheEvictions.reset();
    }

    public long getCacheHits() {
        return this.cacheHits.sum();
    }

    public float getCacheHitPercentage() {
        long hits = this.cacheHits.sum();
        float total = hits + this.cacheMisses.sum();
        if (total <= 0.0f) {
            return 0.0f;
        }
        return (float)hits * 100.0f / total;
    }

    public long getCacheMisses() {
        return this.cacheMisses.sum();
    }

    public float getCacheMissPercentage() {
        long misses = this.cacheMisses.sum();
        float total = misses + this.cacheHits.sum();
        if (total <= 0.0f) {
            return 0.0f;
        }
        return (float)misses * 100.0f / total;
    }

    public long getCacheGets() {
        return this.cacheGets.sum();
    }

    public long getCachePuts() {
        return this.cachePuts.sum();
    }

    public long getCacheRemovals() {
        return this.cacheRemovals.sum();
    }

    public long getCacheEvictions() {
        return this.cacheEvictions.sum();
    }

    public float getAverageGetTime() {
        return this.averageGetTime;
    }

    public float getAveragePutTime() {
        return this.averagePutTime;
    }

    public float getAverageRemoveTime() {
        return this.averageRemoveTime;
    }
}

