/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rhq;

import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.infinispan.rhq.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceComponent;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

public class CacheManagerComponent
extends MBeanResourceComponent<MBeanResourceComponent> {
    private static final Log log = (Log)LogFactory.getLog(CacheManagerComponent.class, Log.class);
    protected ResourceContext<JMXComponent> context;
    private String cacheManagerPattern;

    public AvailabilityType getAvailability() {
        boolean trace = log.isTraceEnabled();
        EmsConnection conn = this.getEmsConnection();
        try {
            conn.refresh();
            EmsBean bean = this.queryCacheManagerBean(conn);
            if (bean != null) {
                bean.refreshAttributes();
                if (trace) {
                    log.tracef("Cache manager %s could be found and attributes where refreshed, so it's up.", bean);
                }
                return AvailabilityType.UP;
            }
            if (trace) {
                log.trace("Cache manager could not be found, so cache manager is down");
            }
            return AvailabilityType.DOWN;
        }
        catch (Exception e) {
            if (trace) {
                log.trace("There was an exception checking availability, so cache manager is down");
            }
            return AvailabilityType.DOWN;
        }
    }

    public void start(ResourceContext context) {
        this.context = context;
        this.cacheManagerPattern = "*:type=CacheManager,name=" + ObjectName.quote(context.getResourceKey()) + ",*";
    }

    public EmsConnection getEmsConnection() {
        return ((JMXComponent)this.context.getParentResourceComponent()).getEmsConnection();
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.tracef("Get values for these metrics: %s", metrics);
        }
        EmsConnection conn = this.getEmsConnection();
        if (trace) {
            log.tracef("Connection to ems server established: %s", conn);
        }
        EmsBean bean = this.queryCacheManagerBean(conn);
        bean.refreshAttributes();
        if (trace) {
            log.tracef("Querying returned bean: %s", bean);
        }
        for (MeasurementScheduleRequest req : metrics) {
            DataType type = req.getDataType();
            if (type == DataType.MEASUREMENT) {
                String tmp = (String)bean.getAttribute(req.getName()).getValue();
                Double val = Double.valueOf(tmp);
                if (trace) {
                    log.tracef("Metric (%s) is measurement with value %s", req.getName(), val);
                }
                MeasurementDataNumeric res = new MeasurementDataNumeric(req, val);
                report.addData(res);
                continue;
            }
            if (type != DataType.TRAIT) continue;
            String value = (String)bean.getAttribute(req.getName()).getValue();
            if (trace) {
                log.tracef("Metric (%s) is trait with value %s", req.getName(), value);
            }
            MeasurementDataTrait res = new MeasurementDataTrait(req, value);
            report.addData(res);
        }
    }

    private EmsBean queryCacheManagerBean(EmsConnection conn) {
        ObjectNameQueryUtility queryUtility;
        List beans;
        String pattern = this.cacheManagerPattern;
        if (log.isTraceEnabled()) {
            log.tracef("Pattern to query is %s", pattern);
        }
        if ((beans = conn.queryBeans((queryUtility = new ObjectNameQueryUtility(pattern)).getTranslatedQuery())).size() > 1) {
            log.moreThanOneBeanReturned(pattern, beans);
        }
        return (EmsBean)beans.get(0);
    }
}

