/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.Util;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.scripting.impl.ExecutionMode;

public class ScriptMetadata
implements Metadata {
    private static final Set<String> TEXT_BASED_MEDIA = Util.asSet((Object[])new String[]{"text/plain", "application/json", "application/xml"});
    @ProtoField(number=1)
    String name;
    @ProtoField(number=2)
    ExecutionMode mode;
    @ProtoField(number=3)
    String extension;
    @ProtoField(number=4, collectionImplementation=HashSet.class)
    Set<String> parameters;
    @ProtoField(number=5)
    MediaType dataType;
    @ProtoField(number=6)
    String language;
    @ProtoField(number=7)
    String role;

    ScriptMetadata() {
    }

    ScriptMetadata(String name, String language, String extension, ExecutionMode mode, Set<String> parameters, String role, MediaType dataType) {
        this.name = name;
        this.language = language;
        this.extension = extension;
        this.mode = mode;
        this.parameters = Collections.unmodifiableSet(parameters);
        this.role = role;
        this.dataType = dataType;
    }

    public Optional<String> language() {
        return Optional.ofNullable(this.language);
    }

    public String extension() {
        return this.extension;
    }

    public Set<String> parameters() {
        return this.parameters;
    }

    public Optional<String> role() {
        return Optional.ofNullable(this.role);
    }

    public String name() {
        return this.name;
    }

    public ExecutionMode mode() {
        return this.mode;
    }

    public MediaType dataType() {
        if (TEXT_BASED_MEDIA.contains(this.dataType.getTypeSubtype())) {
            return this.dataType.withClassType(String.class);
        }
        return this.dataType;
    }

    public long lifespan() {
        return -1L;
    }

    public long maxIdle() {
        return -1L;
    }

    public EntryVersion version() {
        return null;
    }

    public Builder builder() {
        return new Builder().name(this.name).extension(this.extension).mode(this.mode).parameters(this.parameters);
    }

    public String toString() {
        return "ScriptMetadata{name='" + this.name + '\'' + ", mode=" + (Object)((Object)this.mode) + ", extension='" + this.extension + '\'' + ", parameters=" + this.parameters + ", dataType=" + this.dataType + ", language=" + this.language + ", role=" + this.role + '}';
    }

    public static class Builder
    implements Metadata.Builder {
        String name;
        String extension;
        String language;
        String role;
        ExecutionMode mode;
        Set<String> parameters = Collections.emptySet();
        MediaType dataType = MediaType.APPLICATION_OBJECT;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder mode(ExecutionMode mode) {
            this.mode = mode;
            return this;
        }

        public Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder parameters(Set<String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder role(String role) {
            this.role = role;
            return this;
        }

        public Builder dataType(MediaType dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder lifespan(long time, TimeUnit unit) {
            return this;
        }

        public Builder lifespan(long time) {
            return this;
        }

        public Builder maxIdle(long time, TimeUnit unit) {
            return this;
        }

        public Builder maxIdle(long time) {
            return this;
        }

        public Builder version(EntryVersion version) {
            return this;
        }

        public ScriptMetadata build() {
            return new ScriptMetadata(this.name, this.language, this.extension, this.mode, this.parameters, this.role, this.dataType);
        }

        public Builder merge(Metadata metadata) {
            return this;
        }
    }
}

