/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.metadata.Metadata;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.scripting.impl.CacheScriptBindings;
import org.infinispan.scripting.impl.DataTypedCacheManager;
import org.infinispan.scripting.impl.ScriptMetadata;
import org.infinispan.scripting.impl.ScriptMetadataParser;
import org.infinispan.scripting.impl.ScriptRunner;
import org.infinispan.scripting.impl.ScriptingTaskEngine;
import org.infinispan.scripting.impl.SecurityActions;
import org.infinispan.scripting.impl.SystemBindings;
import org.infinispan.scripting.logging.Log;
import org.infinispan.scripting.utils.ScriptConversions;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.impl.AuthorizationHelper;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskManager;
import org.infinispan.tasks.spi.TaskEngine;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class ScriptingManagerImpl
implements ScriptingManager {
    private static final Log log = (Log)LogFactory.getLog(ScriptingManagerImpl.class, Log.class);
    @Inject
    EmbeddedCacheManager cacheManager;
    @Inject
    TaskManager taskManager;
    @Inject
    AuthorizationHelper globalAuthzHelper;
    @Inject
    EncoderRegistry encoderRegistry;
    @Inject
    GlobalConfiguration globalConfiguration;
    private ScriptEngineManager scriptEngineManager;
    private ConcurrentMap<String, ScriptEngine> scriptEnginesByExtension = new ConcurrentHashMap<String, ScriptEngine>(2);
    private ConcurrentMap<String, ScriptEngine> scriptEnginesByLanguage = new ConcurrentHashMap<String, ScriptEngine>(2);
    private Cache<String, String> scriptCache;
    private ScriptConversions scriptConversions;
    ConcurrentMap<String, CompiledScript> compiledScripts = new ConcurrentHashMap<String, CompiledScript>();
    private final Function<String, ScriptEngine> getEngineByName = this::getEngineByName;
    private final Function<String, ScriptEngine> getEngineByExtension = this::getEngineByExtension;

    @Start
    public void start() {
        ClassLoader classLoader = this.globalConfiguration.classLoader();
        this.scriptEngineManager = new ScriptEngineManager(classLoader);
        this.taskManager.registerTaskEngine((TaskEngine)new ScriptingTaskEngine(this));
        this.scriptConversions = new ScriptConversions(this.encoderRegistry);
    }

    Cache<String, String> getScriptCache() {
        if (this.scriptCache == null) {
            this.scriptCache = this.cacheManager.getCache("___script_cache");
        }
        return this.scriptCache;
    }

    ScriptMetadata compileScript(String name, String script) {
        ScriptMetadata metadata = ScriptMetadataParser.parse(name, script);
        ScriptEngine engine = this.getEngineForScript(metadata);
        if (engine instanceof Compilable) {
            try {
                CompiledScript compiledScript = ((Compilable)((Object)engine)).compile(script);
                this.compiledScripts.put(name, compiledScript);
                return metadata;
            }
            catch (ScriptException e) {
                throw log.scriptCompilationException(e, name);
            }
        }
        return null;
    }

    @Override
    public void addScript(String name, String script) {
        ScriptMetadata metadata = ScriptMetadataParser.parse(name, script);
        ScriptEngine engine = this.getEngineForScript(metadata);
        if (engine == null) {
            throw log.noScriptEngineForScript(name);
        }
        this.getScriptCache().getAdvancedCache().put((Object)name, (Object)script, (Metadata)metadata);
    }

    @Override
    public void removeScript(String name) {
        if (!this.containsScript(name)) {
            throw log.noNamedScript(name);
        }
        this.getScriptCache().remove((Object)name);
    }

    @Override
    public String getScript(String name) {
        if (this.containsScript(name)) {
            return (String)SecurityActions.getUnwrappedCache(this.getScriptCache()).get((Object)name);
        }
        throw log.noNamedScript(name);
    }

    @Override
    public Set<String> getScriptNames() {
        return SecurityActions.getUnwrappedCache(this.getScriptCache()).keySet();
    }

    boolean containsScript(String taskName) {
        return SecurityActions.getUnwrappedCache(this.getScriptCache()).containsKey((Object)taskName);
    }

    @Override
    public <T> CompletableFuture<T> runScript(String scriptName) {
        return this.runScript(scriptName, new TaskContext());
    }

    @Override
    public <T> CompletableFuture<T> runScript(String scriptName, TaskContext context) {
        ScriptMetadata metadata = this.getScriptMetadata(scriptName);
        if (this.globalAuthzHelper != null) {
            AuthorizationManager authorizationManager;
            AuthorizationManager authorizationManager2 = authorizationManager = context.getCache().isPresent() ? SecurityActions.getAuthorizationManager(((Cache)context.getCache().get()).getAdvancedCache()) : null;
            if (authorizationManager != null) {
                authorizationManager.checkPermission(AuthorizationPermission.EXEC, (String)metadata.role().orElse(null));
            } else {
                this.globalAuthzHelper.checkPermission(AuthorizationPermission.EXEC, (String)metadata.role().orElse(null));
            }
        }
        String scriptMediaType = metadata.dataType().toString();
        MediaType requestMediaType = context.getCache().map(c -> c.getAdvancedCache().getValueDataConversion().getRequestMediaType()).orElse(MediaType.MATCH_ALL);
        Bindings userBindings = context.getParameters().map(p -> {
            Map<String, Object> params = this.scriptConversions.convertParameters(context);
            return new SimpleBindings(params);
        }).orElse(new SimpleBindings());
        SimpleBindings systemBindings = new SimpleBindings();
        DataTypedCacheManager dataTypedCacheManager = new DataTypedCacheManager(scriptMediaType, this.cacheManager, context.getSubject().orElse(null));
        systemBindings.put(SystemBindings.CACHE_MANAGER.toString(), (Object)dataTypedCacheManager);
        systemBindings.put(SystemBindings.SCRIPTING_MANAGER.toString(), (Object)this);
        context.getCache().ifPresent(cache -> {
            if (requestMediaType != null && !requestMediaType.equals((Object)MediaType.MATCH_ALL)) {
                cache = cache.getAdvancedCache().withMediaType(scriptMediaType, scriptMediaType);
            }
            systemBindings.put(SystemBindings.CACHE.toString(), cache);
        });
        context.getMarshaller().ifPresent(marshaller -> systemBindings.put(SystemBindings.MARSHALLER.toString(), marshaller));
        CacheScriptBindings bindings = new CacheScriptBindings(systemBindings, userBindings);
        ScriptRunner runner = metadata.mode().getRunner();
        return runner.runScript(this, metadata, bindings).thenApply(t -> this.scriptConversions.convertToRequestType(t, metadata.dataType(), requestMediaType));
    }

    ScriptMetadata getScriptMetadata(String scriptName) {
        CacheEntry scriptEntry = SecurityActions.getCacheEntry(this.getScriptCache().getAdvancedCache(), scriptName);
        if (scriptEntry == null) {
            throw log.noNamedScript(scriptName);
        }
        return (ScriptMetadata)scriptEntry.getMetadata();
    }

    <T> CompletableFuture<T> execute(ScriptMetadata metadata, Bindings bindings) {
        CompiledScript compiled = (CompiledScript)this.compiledScripts.get(metadata.name());
        try {
            if (compiled != null) {
                Object result = compiled.eval(bindings);
                return CompletableFuture.completedFuture(result);
            }
            ScriptEngine engine = this.getEngineForScript(metadata);
            String script = (String)this.getScriptCache().get((Object)metadata.name());
            Object result = engine.eval(script, bindings);
            return CompletableFuture.completedFuture(result);
        }
        catch (ScriptException e) {
            throw log.scriptExecutionError(e);
        }
    }

    ScriptEngine getEngineForScript(ScriptMetadata metadata) {
        ScriptEngine engine = metadata.language().isPresent() ? this.scriptEnginesByLanguage.computeIfAbsent(metadata.language().get(), this.getEngineByName) : this.scriptEnginesByExtension.computeIfAbsent(metadata.extension(), this.getEngineByExtension);
        if (engine == null) {
            throw log.noEngineForScript(metadata.name());
        }
        return engine;
    }

    private ScriptEngine getEngineByName(String shortName) {
        return ScriptingManagerImpl.withClassLoader(ScriptingManagerImpl.class.getClassLoader(), this.scriptEngineManager, shortName, ScriptEngineManager::getEngineByName);
    }

    private ScriptEngine getEngineByExtension(String extension) {
        return ScriptingManagerImpl.withClassLoader(ScriptingManagerImpl.class.getClassLoader(), this.scriptEngineManager, extension, ScriptEngineManager::getEngineByExtension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScriptEngine withClassLoader(ClassLoader cl, ScriptEngineManager manager, String name, BiFunction<ScriptEngineManager, String, ScriptEngine> f) {
        ClassLoader curr = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            ScriptEngine scriptEngine = f.apply(manager, name);
            return scriptEngine;
        }
        finally {
            Thread.currentThread().setContextClassLoader(curr);
        }
    }
}

