/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting;

import java.security.PrivilegedActionException;
import java.util.concurrent.ExecutionException;
import javax.security.auth.Subject;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.scripting.AbstractScriptingTest;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.tasks.TaskContext;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scripting.SecureScriptingTest")
public class SecureScriptingTest
extends AbstractScriptingTest {
    static final Subject ADMIN = TestingUtil.makeSubject((String[])new String[]{"admin", "___script_manager"});
    static final Subject RUNNER = TestingUtil.makeSubject((String[])new String[]{"runner", "runner"});
    static final Subject PHEIDIPPIDES = TestingUtil.makeSubject((String[])new String[]{"pheidippides", "pheidippides"});
    static final Subject ACHILLES = TestingUtil.makeSubject((String[])new String[]{"achilles", "achilles"});
    static final String SECURE_CACHE_NAME = "secured-script-exec";

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        GlobalAuthorizationConfigurationBuilder globalRoles = global.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper());
        ConfigurationBuilder config = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        AuthorizationConfigurationBuilder authConfig = config.security().authorization().enable();
        globalRoles.role("achilles").permission(AuthorizationPermission.READ).permission(AuthorizationPermission.WRITE).role("runner").permission(AuthorizationPermission.EXEC).permission(AuthorizationPermission.READ).permission(AuthorizationPermission.WRITE).role("pheidippides").permission(AuthorizationPermission.EXEC).permission(AuthorizationPermission.READ).permission(AuthorizationPermission.WRITE).role("admin").permission(AuthorizationPermission.ALL);
        authConfig.role("runner").role("pheidippides").role("admin");
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)global, (ConfigurationBuilder)config);
        Security.doAs((Subject)ADMIN, () -> {
            cm.defineConfiguration("script-exec", cm.getDefaultCacheConfiguration());
            cm.getCache("script-exec");
            cm.defineConfiguration(SECURE_CACHE_NAME, cm.getDefaultCacheConfiguration());
            cm.getCache(SECURE_CACHE_NAME);
            cm.defineConfiguration("nonSecuredCache", TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true).build());
            return null;
        });
        return cm;
    }

    @Override
    protected String[] getScripts() {
        return new String[]{"test.js", "testRole.js", "testRoleWithCache.js"};
    }

    @Override
    protected void setup() throws Exception {
        Security.doAs((Subject)ADMIN, () -> {
            SecureScriptingTest.super.setup();
            return null;
        });
    }

    protected void teardown() {
        Security.doAs((Subject)ADMIN, () -> {
            SecureScriptingTest.super.teardown();
            return null;
        });
    }

    protected void clearContent() {
        Security.doAs((Subject)ADMIN, () -> {
            this.cacheManager.getCache().clear();
            return null;
        });
    }

    @Test(expectedExceptions={SecurityException.class})
    public void testSimpleScript() throws Exception {
        String result = (String)this.scriptingManager.runScript("test.js", new TaskContext().addParameter("a", (Object)"a")).get();
        AssertJUnit.assertEquals((String)"a", (String)result);
    }

    public void testSimpleScriptWithEXECPermissions() throws Exception {
        String result = (String)Security.doAs((Subject)RUNNER, () -> (String)this.scriptingManager.runScript("test.js", new TaskContext().addParameter("a", (Object)"a")).get());
        AssertJUnit.assertEquals((String)"a", (String)result);
    }

    @Test(expectedExceptions={PrivilegedActionException.class})
    public void testSimpleScriptWithEXECPermissionsWrongRole() throws Exception {
        String result = (String)Security.doAs((Subject)RUNNER, () -> (String)this.scriptingManager.runScript("testRole.js", new TaskContext().addParameter("a", (Object)"a")).get());
        AssertJUnit.assertEquals((String)"a", (String)result);
    }

    public void testSimpleScriptWithEXECPermissionsRightRole() throws Exception {
        String result = (String)Security.doAs((Subject)PHEIDIPPIDES, () -> (String)this.scriptingManager.runScript("testRole.js", new TaskContext().addParameter("a", (Object)"a")).get());
        AssertJUnit.assertEquals((String)"a", (String)result);
    }

    @Test(expectedExceptions={PrivilegedActionException.class})
    public void testSimpleScriptWithoutEXEC() throws Exception {
        Security.doAs((Subject)ACHILLES, () -> (String)this.scriptingManager.runScript("testRole.js", new TaskContext().addParameter("a", (Object)"a")).get());
    }

    @Test(expectedExceptions={PrivilegedActionException.class})
    public void testUploadScriptWithEXECNotManager() throws Exception {
        Security.doAs((Subject)PHEIDIPPIDES, () -> {
            this.scriptingManager.addScript("my_script", "1+1");
            return null;
        });
    }

    @Test(expectedExceptions={PrivilegedActionException.class})
    public void testUploadScriptWithoutEXECNotManager() throws Exception {
        Security.doAs((Subject)ACHILLES, () -> {
            this.scriptingManager.addScript("my_script", "1+1");
            return null;
        });
    }

    @Test(expectedExceptions={PrivilegedActionException.class})
    public void testRemoveScriptWithEXECNotManager() throws Exception {
        Security.doAs((Subject)PHEIDIPPIDES, () -> {
            this.scriptingManager.removeScript("test.js");
            return null;
        });
    }

    @Test(expectedExceptions={PrivilegedActionException.class})
    public void testUploadScriptDirectlyWithEXECNotManager() throws Exception {
        Security.doAs((Subject)PHEIDIPPIDES, () -> {
            this.cacheManager.getCache("___script_cache").put((Object)"my_script", (Object)"1+1");
            return null;
        });
    }

    @Test(expectedExceptions={PrivilegedActionException.class})
    public void testRemoveScriptDirectlyWithEXECNotManager() throws Exception {
        Security.doAs((Subject)PHEIDIPPIDES, () -> {
            this.cacheManager.getCache("___script_cache").remove((Object)"test.js");
            return null;
        });
    }

    @Test(expectedExceptions={PrivilegedActionException.class})
    public void testClearScriptDirectlyWithEXECNotManager() throws Exception {
        Security.doAs((Subject)PHEIDIPPIDES, () -> {
            this.cacheManager.getCache("___script_cache").clear();
            return null;
        });
    }

    public void testScriptOnNonSecuredCache() throws ExecutionException, InterruptedException, PrivilegedActionException {
        Cache nonSecCache = this.cache("nonSecuredCache");
        nonSecCache.put((Object)"a", (Object)"value");
        AssertJUnit.assertEquals((String)"value", (String)((String)nonSecCache.get((Object)"a")));
        String result = (String)Security.doAs((Subject)PHEIDIPPIDES, () -> (String)this.scriptingManager.runScript("testRoleWithCache.js", new TaskContext().addParameter("a", (Object)"a").cache(nonSecCache)).get());
        AssertJUnit.assertEquals((String)"a", (String)result);
        AssertJUnit.assertEquals((String)"a", (String)((String)nonSecCache.get((Object)"a")));
    }

    @Test(expectedExceptions={PrivilegedActionException.class})
    public void testScriptOnNonSecuredCacheWrongRole() throws ExecutionException, InterruptedException, PrivilegedActionException {
        Security.doAs((Subject)RUNNER, () -> (String)this.scriptingManager.runScript("testRoleWithCache.js", new TaskContext().addParameter("a", (Object)"a").cache(this.cache("nonSecuredCache"))).get());
    }
}

