package org.infinispan.scripting.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.infinispan.commons.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-05-24T16:19:03-0400")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String scriptExecutionError = "ISPN027503: Script execution error";
    protected String scriptExecutionError$str() {
        return scriptExecutionError;
    }
    @Override
    public final CacheException scriptExecutionError(final Throwable t) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), scriptExecutionError$str()), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String scriptCompilationException = "ISPN027504: Compiler error for script '%s'";
    protected String scriptCompilationException$str() {
        return scriptCompilationException;
    }
    @Override
    public final CacheException scriptCompilationException(final Throwable t, final String name) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), scriptCompilationException$str(), name), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noNamedScript = "ISPN027505: No script named '%s'";
    protected String noNamedScript$str() {
        return noNamedScript;
    }
    @Override
    public final CacheException noNamedScript(final String name) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), noNamedScript$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownScriptProperty = "ISPN027506: Unknown script mode: '%s'";
    protected String unknownScriptProperty$str() {
        return unknownScriptProperty;
    }
    @Override
    public final CacheException unknownScriptProperty(final String value) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unknownScriptProperty$str(), value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noScriptEngineForScript = "ISPN027507: Cannot find an appropriate script engine for '%s'";
    protected String noScriptEngineForScript$str() {
        return noScriptEngineForScript;
    }
    @Override
    public final IllegalArgumentException noScriptEngineForScript(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noScriptEngineForScript$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInvokeScriptDirectly = "ISPN027508: Script '%s' cannot be invoked directly since it specifies mode '%s'";
    protected String cannotInvokeScriptDirectly$str() {
        return cannotInvokeScriptDirectly;
    }
    @Override
    public final IllegalArgumentException cannotInvokeScriptDirectly(final String scriptName, final String property) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotInvokeScriptDirectly$str(), scriptName, property));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String distributedTaskNeedCacheInBinding = "ISPN027509: Distributed script '%s' invoked without a cache binding";
    protected String distributedTaskNeedCacheInBinding$str() {
        return distributedTaskNeedCacheInBinding;
    }
    @Override
    public final IllegalStateException distributedTaskNeedCacheInBinding(final String scriptName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), distributedTaskNeedCacheInBinding$str(), scriptName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noEngineForScript = "ISPN027510: Cannot find an appropriate script engine for script '%s'";
    protected String noEngineForScript$str() {
        return noEngineForScript;
    }
    @Override
    public final IllegalArgumentException noEngineForScript(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noEngineForScript$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String parametersNotArray = "ISPN027511: Script parameters must be declared using the array notation, e.g. [a,b,c]";
    protected String parametersNotArray$str() {
        return parametersNotArray;
    }
    @Override
    public final IllegalArgumentException parametersNotArray() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), parametersNotArray$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String scriptsCanOnlyAccessNamedCaches = "ISPN027512: Scripts can only access named caches";
    protected String scriptsCanOnlyAccessNamedCaches$str() {
        return scriptsCanOnlyAccessNamedCaches;
    }
    @Override
    public final IllegalArgumentException scriptsCanOnlyAccessNamedCaches() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), scriptsCanOnlyAccessNamedCaches$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
