/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting;

import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.scripting.impl.ScriptTask;
import org.infinispan.scripting.utils.ScriptingUtils;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskExecutionMode;
import org.infinispan.tasks.TaskManager;
import org.infinispan.tasks.spi.TaskEngine;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scripting.ScriptingTaskManagerTest")
@CleanupAfterMethod
public class ScriptingTaskManagerTest
extends SingleCacheManagerTest {
    protected static final String TEST_SCRIPT = "test.js";
    protected static final String BROKEN_SCRIPT = "brokenTest.js";
    protected TaskManager taskManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager();
    }

    protected void setup() throws Exception {
        super.setup();
        this.taskManager = (TaskManager)TestingUtil.extractGlobalComponent((CacheContainer)this.cacheManager, TaskManager.class);
        this.cacheManager.defineConfiguration("script-exec", new ConfigurationBuilder().build());
    }

    public void testTask() throws Exception {
        ScriptingManager scriptingManager = (ScriptingManager)TestingUtil.extractGlobalComponent((CacheContainer)this.cacheManager, ScriptingManager.class);
        ScriptingUtils.loadScript(scriptingManager, TEST_SCRIPT);
        String result = (String)CompletionStages.join((CompletionStage)this.taskManager.runTask(TEST_SCRIPT, new TaskContext().addParameter("a", (Object)"a")));
        AssertJUnit.assertEquals((String)"a", (String)result);
        List tasks = this.taskManager.getTasks();
        AssertJUnit.assertEquals((int)1, (int)tasks.size());
        ScriptTask scriptTask = (ScriptTask)tasks.get(0);
        AssertJUnit.assertEquals((String)TEST_SCRIPT, (String)scriptTask.getName());
        AssertJUnit.assertEquals((Object)TaskExecutionMode.ONE_NODE, (Object)scriptTask.getExecutionMode());
        AssertJUnit.assertEquals((String)"Script", (String)scriptTask.getType());
    }

    public void testAvailableEngines() {
        List engines = this.taskManager.getEngines();
        AssertJUnit.assertEquals((int)1, (int)engines.size());
        AssertJUnit.assertEquals((String)"Script", (String)((TaskEngine)engines.get(0)).getName());
    }

    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp=".*Script execution error.*")
    public void testBrokenTask() throws Exception {
        ScriptingManager scriptingManager = (ScriptingManager)TestingUtil.extractGlobalComponent((CacheContainer)this.cacheManager, ScriptingManager.class);
        ScriptingUtils.loadScript(scriptingManager, BROKEN_SCRIPT);
        CompletionStages.join((CompletionStage)this.taskManager.runTask(BROKEN_SCRIPT, new TaskContext()));
    }
}

