/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.infinispan.Cache;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.scripting.utils.ScriptingUtils;
import org.infinispan.tasks.TaskContext;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultiCacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scripting.ClusteredScriptingTest")
public class ClusteredScriptingTest
extends AbstractInfinispanTest {
    private static final int EXPECTED_WORDS = 3202;

    @Test(dataProvider="cacheModeProvider")
    public void testLocalScriptExecutionWithCache(CacheMode cacheMode) {
        TestingUtil.withCacheManagers((MultiCacheManagerCallable)new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager((CacheMode)cacheMode, (boolean)false), TestCacheManagerFactory.createCacheManager((CacheMode)cacheMode, (boolean)false)}){

            public void call() throws IOException, ExecutionException, InterruptedException {
                ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.cms[0]);
                Configuration configuration = new ConfigurationBuilder().encoding().key().mediaType("application/x-java-object").encoding().value().mediaType("application/x-java-object").build();
                for (EmbeddedCacheManager cm : this.cms) {
                    cm.defineConfiguration("script-exec", configuration);
                }
                ScriptingUtils.loadScript(scriptingManager, "/test.js");
                ClusteredScriptingTest.this.executeScriptOnManager("test.js", this.cms[0]);
                ClusteredScriptingTest.this.executeScriptOnManager("test.js", this.cms[1]);
            }
        });
    }

    @Test(dataProvider="cacheModeProvider")
    public void testLocalScriptExecutionWithCache1(CacheMode cacheMode) {
        TestingUtil.withCacheManagers((MultiCacheManagerCallable)new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager((CacheMode)cacheMode, (boolean)false), TestCacheManagerFactory.createCacheManager((CacheMode)cacheMode, (boolean)false)}){

            public void call() throws Exception {
                Configuration configuration = new ConfigurationBuilder().encoding().key().mediaType("application/x-java-object").encoding().value().mediaType("application/x-java-object").build();
                for (EmbeddedCacheManager cm : this.cms) {
                    cm.defineConfiguration("script-exec", configuration);
                }
                Cache cache = this.cms[0].getCache("script-exec");
                ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.cms[0]);
                ScriptingUtils.loadScript(scriptingManager, "/test1.js");
                cache.put((Object)"a", (Object)"newValue");
                ClusteredScriptingTest.this.executeScriptOnManager("test1.js", this.cms[0]);
                ClusteredScriptingTest.this.executeScriptOnManager("test1.js", this.cms[1]);
            }
        });
    }

    @Test(dataProvider="cacheModeProvider")
    public void testDistExecScriptWithCache(CacheMode cacheMode) {
        TestingUtil.withCacheManagers((MultiCacheManagerCallable)new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager((CacheMode)cacheMode, (boolean)false), TestCacheManagerFactory.createCacheManager((CacheMode)cacheMode, (boolean)false)}){

            public void call() throws Exception {
                Cache cache1 = this.cms[0].getCache();
                Cache cache2 = this.cms[1].getCache();
                ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.cms[0]);
                ScriptingUtils.loadScript(scriptingManager, "/distExec1.js");
                TestingUtil.waitForNoRebalance((Cache[])new Cache[]{cache1, cache2});
                CompletableFuture resultsFuture = scriptingManager.runScript("distExec1.js", new TaskContext().cache(cache1));
                ArrayList results = (ArrayList)resultsFuture.get();
                AssertJUnit.assertEquals((int)2, (int)results.size());
                AssertJUnit.assertTrue((boolean)results.contains(this.cms[0].getAddress()));
                AssertJUnit.assertTrue((boolean)results.contains(this.cms[1].getAddress()));
            }
        });
    }

    @Test(dataProvider="cacheModeProvider")
    public void testDistExecScriptWithCacheManagerAndParams(CacheMode cacheMode) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(cacheMode).encoding().key().mediaType("application/x-java-object").encoding().value().mediaType("application/x-java-object");
        TestingUtil.withCacheManagers((MultiCacheManagerCallable)new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)builder), TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)builder)}){

            public void call() throws Exception {
                Cache cache1 = this.cms[0].getCache();
                Cache cache2 = this.cms[1].getCache();
                ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.cms[0]);
                ScriptingUtils.loadScript(scriptingManager, "/distExec.js");
                TestingUtil.waitForNoRebalance((Cache[])new Cache[]{cache1, cache2});
                CompletableFuture resultsFuture = scriptingManager.runScript("distExec.js", new TaskContext().cache(cache1).addParameter("a", (Object)"value"));
                ArrayList results = (ArrayList)resultsFuture.get();
                AssertJUnit.assertEquals((int)2, (int)results.size());
                AssertJUnit.assertTrue((boolean)results.contains(this.cms[0].getAddress()));
                AssertJUnit.assertTrue((boolean)results.contains(this.cms[1].getAddress()));
                AssertJUnit.assertEquals((Object)"value", (Object)cache1.get((Object)"a"));
                AssertJUnit.assertEquals((Object)"value", (Object)cache2.get((Object)"a"));
            }
        });
    }

    @Test(expectedExceptions={IllegalStateException.class}, dataProvider="cacheModeProvider", expectedExceptionsMessageRegExp=".*without a cache binding.*")
    public void testDistributedScriptExecutionWithoutCacheBinding(CacheMode cacheMode) {
        TestingUtil.withCacheManagers((MultiCacheManagerCallable)new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager((CacheMode)cacheMode, (boolean)false), TestCacheManagerFactory.createCacheManager((CacheMode)cacheMode, (boolean)false)}){

            public void call() throws Exception {
                ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.cms[0]);
                ScriptingUtils.loadScript(scriptingManager, "/distExec.js");
                scriptingManager.runScript("distExec.js").get();
            }
        });
    }

    @Test(dataProvider="cacheModeProvider")
    public void testDistributedMapReduceStreamWithFlag(CacheMode cacheMode) {
        TestingUtil.withCacheManagers((MultiCacheManagerCallable)new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager((CacheMode)cacheMode, (boolean)false), TestCacheManagerFactory.createCacheManager((CacheMode)cacheMode, (boolean)false)}){

            public void call() throws Exception {
                ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.cms[0]);
                Cache cache1 = this.cms[0].getCache();
                Cache cache2 = this.cms[1].getCache();
                ScriptingUtils.loadData((BasicCache<String, String>)cache1, "/macbeth.txt");
                ScriptingUtils.loadScript(scriptingManager, "/wordCountStream.js");
                TestingUtil.waitForNoRebalance((Cache[])new Cache[]{cache1, cache2});
                Map resultsFuture = (Map)scriptingManager.runScript("wordCountStream.js", new TaskContext().cache((Cache)cache1.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL))).get();
                AssertJUnit.assertEquals((int)3202, (int)resultsFuture.size());
                AssertJUnit.assertEquals(resultsFuture.get("macbeth"), (Object)287L);
                resultsFuture = (Map)scriptingManager.runScript("wordCountStream.js", new TaskContext().cache((Cache)cache1.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL))).get();
                AssertJUnit.assertEquals((int)3202, (int)resultsFuture.size());
                AssertJUnit.assertEquals(resultsFuture.get("macbeth"), (Object)287L);
            }
        });
    }

    @Test(enabled=false, dataProvider="cacheModeProvider", description="Disabled due to ISPN-6173.")
    public void testDistributedMapReduceStreamLocalMode(CacheMode cacheMode) throws IOException, ExecutionException, InterruptedException {
        TestingUtil.withCacheManagers((MultiCacheManagerCallable)new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager((CacheMode)cacheMode, (boolean)false), TestCacheManagerFactory.createCacheManager((CacheMode)cacheMode, (boolean)false)}){

            public void call() throws Exception {
                ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.cms[0]);
                Cache cache1 = this.cms[0].getCache();
                Cache cache2 = this.cms[1].getCache();
                ScriptingUtils.loadData((BasicCache<String, String>)cache1, "/macbeth.txt");
                ScriptingUtils.loadScript(scriptingManager, "/wordCountStream_serializable.js");
                TestingUtil.waitForNoRebalance((Cache[])new Cache[]{cache1, cache2});
                ArrayList resultsFuture = (ArrayList)scriptingManager.runScript("wordCountStream_serializable.js", new TaskContext().cache(cache1)).get();
                AssertJUnit.assertEquals((int)2, (int)resultsFuture.size());
                AssertJUnit.assertEquals((int)3202, (int)((Map)resultsFuture.get(0)).size());
                AssertJUnit.assertEquals((int)3202, (int)((Map)resultsFuture.get(1)).size());
                AssertJUnit.assertEquals(((Map)resultsFuture.get(0)).get("macbeth"), (Object)287L);
                AssertJUnit.assertEquals(((Map)resultsFuture.get(1)).get("macbeth"), (Object)287L);
            }
        });
    }

    @Test(enabled=false, dataProvider="cacheModeProvider", description="Disabled due to ISPN-6173.")
    public void testDistributedMapReduceStreamLocalModeWithExecutors(CacheMode cacheMode) throws IOException, ExecutionException, InterruptedException {
        TestingUtil.withCacheManagers((MultiCacheManagerCallable)new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager((CacheMode)cacheMode, (boolean)false), TestCacheManagerFactory.createCacheManager((CacheMode)cacheMode, (boolean)false)}){

            public void call() throws Exception {
                ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.cms[0]);
                Cache cache1 = this.cms[0].getCache();
                Cache cache2 = this.cms[1].getCache();
                ScriptingUtils.loadData((BasicCache<String, String>)cache1, "/macbeth.txt");
                ScriptingUtils.loadScript(scriptingManager, "/wordCountStream_Exec.js");
                TestingUtil.waitForNoRebalance((Cache[])new Cache[]{cache1, cache2});
                ArrayList resultsFuture = (ArrayList)scriptingManager.runScript("wordCountStream_Exec.js", new TaskContext().cache(cache1)).get();
                AssertJUnit.assertEquals((int)2, (int)resultsFuture.size());
                AssertJUnit.assertEquals((int)3202, (int)((Map)resultsFuture.get(0)).size());
                AssertJUnit.assertEquals((int)3202, (int)((Map)resultsFuture.get(1)).size());
                AssertJUnit.assertEquals(((Map)resultsFuture.get(0)).get("macbeth"), (Object)287L);
                AssertJUnit.assertEquals(((Map)resultsFuture.get(1)).get("macbeth"), (Object)287L);
            }
        });
    }

    @Test(enabled=false, dataProvider="cacheModeProvider", description="Disabled due to ISPN-6173.")
    public void testDistributedMapReduceStream(CacheMode cacheMode) throws IOException, ExecutionException, InterruptedException {
        TestingUtil.withCacheManagers((MultiCacheManagerCallable)new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager((CacheMode)cacheMode, (boolean)false), TestCacheManagerFactory.createCacheManager((CacheMode)cacheMode, (boolean)false)}){

            public void call() throws Exception {
                ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(this.cms[0]);
                Cache cache1 = this.cms[0].getCache();
                Cache cache2 = this.cms[1].getCache();
                ScriptingUtils.loadData((BasicCache<String, String>)cache1, "/macbeth.txt");
                ScriptingUtils.loadScript(scriptingManager, "/wordCountStream_dist.js");
                TestingUtil.waitForNoRebalance((Cache[])new Cache[]{cache1, cache2});
                ArrayList resultsFuture = (ArrayList)scriptingManager.runScript("wordCountStream_dist.js", new TaskContext().cache(cache1)).get();
                AssertJUnit.assertEquals((int)2, (int)resultsFuture.size());
                AssertJUnit.assertEquals((int)3202, (int)((Map)resultsFuture.get(0)).size());
                AssertJUnit.assertEquals((int)3202, (int)((Map)resultsFuture.get(1)).size());
                AssertJUnit.assertEquals(((Map)resultsFuture.get(0)).get("macbeth"), (Object)287L);
                AssertJUnit.assertEquals(((Map)resultsFuture.get(1)).get("macbeth"), (Object)287L);
            }
        });
    }

    private void executeScriptOnManager(String scriptName, EmbeddedCacheManager cacheManager) throws InterruptedException, ExecutionException {
        ScriptingManager scriptingManager = ScriptingUtils.getScriptingManager(cacheManager);
        String value = (String)scriptingManager.runScript(scriptName, new TaskContext().addParameter("a", (Object)"value")).get();
        AssertJUnit.assertEquals((Object)value, (Object)cacheManager.getCache("script-exec").get((Object)"a"));
    }

    @DataProvider(name="cacheModeProvider")
    private static Object[][] provideCacheMode() {
        return new Object[][]{{CacheMode.REPL_SYNC}, {CacheMode.DIST_SYNC}};
    }
}

