/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.scripting.AbstractScriptingTest;
import org.infinispan.scripting.utils.ScriptingUtils;
import org.infinispan.tasks.TaskContext;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scripting.ScriptingTest")
@CleanupAfterMethod
public class ScriptingTest
extends AbstractScriptingTest {
    static final String CACHE_NAME = "script-exec";

    @Override
    protected String[] getScripts() {
        return new String[]{"test.js", "testMissingMetaProps.js", "testExecWithoutProp.js", "testInnerScriptCall.js"};
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.encoding().key().mediaType("application/x-java-object");
        builder.encoding().value().mediaType("application/x-java-object");
        this.cacheManager.defineConfiguration(CACHE_NAME, builder.build());
    }

    protected void clearContent() {
        this.cacheManager.getCache().clear();
    }

    public void testSimpleScript() throws Exception {
        String result = (String)this.scriptingManager.runScript("test.js", new TaskContext().addParameter("a", (Object)"a")).get();
        AssertJUnit.assertEquals((String)"a", (String)result);
    }

    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp=".*No script named.*")
    public void testScriptRemove() throws Exception {
        this.scriptingManager.getScript("testExecWithoutProp.js");
        this.scriptingManager.removeScript("testExecWithoutProp.js");
        this.scriptingManager.getScript("testExecWithoutProp.js");
    }

    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp=".*No script named.*")
    public void testRunNonExistentScript() throws Exception {
        String result = (String)this.scriptingManager.runScript("nonExistent.js", new TaskContext().addParameter("a", (Object)"a")).get();
        AssertJUnit.assertEquals((String)"a", (String)result);
    }

    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp=".*Script execution error.*")
    public void testSimpleScriptWitoutPassingParameter() throws Exception {
        String result = (String)this.scriptingManager.runScript("test.js").get();
        AssertJUnit.assertEquals((String)"a", (String)result);
    }

    public void testSimpleScriptReplacementWithNew() throws ExecutionException, InterruptedException, IOException {
        String result = (String)this.scriptingManager.runScript("test.js", new TaskContext().addParameter("a", (Object)"a")).get();
        AssertJUnit.assertEquals((String)"a", (String)result);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/test1.js");
        String script = CommonsTestingUtil.loadFileAsString((InputStream)is);
        this.scriptingManager.addScript("test.js", script);
        result = (String)this.scriptingManager.runScript("test.js").get();
        AssertJUnit.assertEquals((String)"a:modified", (String)result);
        is = ((Object)((Object)this)).getClass().getResourceAsStream("/test.js");
        script = CommonsTestingUtil.loadFileAsString((InputStream)is);
        this.scriptingManager.addScript("test.js", script);
    }

    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp=".*No script named.*")
    public void testScriptingCacheClear() throws Exception {
        String result = (String)this.scriptingManager.runScript("test.js", new TaskContext().addParameter("a", (Object)"a")).get();
        AssertJUnit.assertEquals((String)"a", (String)result);
        this.cache("___script_cache").clear();
        result = (String)this.scriptingManager.runScript("test.js", new TaskContext().addParameter("a", (Object)"a")).get();
        AssertJUnit.assertEquals((String)"a", (String)result);
    }

    public void testScriptingCacheManualReplace() throws Exception {
        String result = (String)this.scriptingManager.runScript("test.js", new TaskContext().addParameter("a", (Object)"a")).get();
        AssertJUnit.assertEquals((String)"a", (String)result);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/test1.js");
        String script = CommonsTestingUtil.loadFileAsString((InputStream)is);
        this.cache("___script_cache").replace((Object)"test.js", (Object)script);
        result = (String)this.scriptingManager.runScript("test.js").get();
        AssertJUnit.assertEquals((String)"a:modified", (String)result);
        is = ((Object)((Object)this)).getClass().getResourceAsStream("/test.js");
        script = CommonsTestingUtil.loadFileAsString((InputStream)is);
        this.scriptingManager.addScript("test.js", script);
    }

    public void testSimpleScript1() throws Exception {
        String value = "javaValue";
        String key = "processValue";
        this.cacheManager.getCache(CACHE_NAME).put((Object)key, (Object)value);
        CompletableFuture exec = this.scriptingManager.runScript("testExecWithoutProp.js");
        exec.get(1000L, TimeUnit.MILLISECONDS);
        AssertJUnit.assertEquals((Object)(value + ":additionFromJavascript"), (Object)this.cacheManager.getCache(CACHE_NAME).get((Object)key));
    }

    public void testScriptCallFromJavascript() throws Exception {
        String result = (String)this.scriptingManager.runScript("testInnerScriptCall.js", new TaskContext().cache(this.cacheManager.getCache(CACHE_NAME)).addParameter("a", (Object)"ahoj")).get();
        AssertJUnit.assertEquals((String)"script1:additionFromJavascript", (String)result);
        AssertJUnit.assertEquals((Object)"ahoj", (Object)this.cacheManager.getCache(CACHE_NAME).get((Object)"a"));
    }

    public void testSimpleScriptWithMissingLanguageInMetaPropeties() throws Exception {
        String result = (String)this.scriptingManager.runScript("testMissingMetaProps.js", new TaskContext().addParameter("a", (Object)"a")).get();
        AssertJUnit.assertEquals((String)"a", (String)result);
    }

    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp=".*No script named.*")
    public void testRemovingNonExistentScript() {
        this.scriptingManager.removeScript("nonExistent");
    }

    public void testRemovingScript() throws IOException, ExecutionException, InterruptedException {
        AssertJUnit.assertNotNull((Object)this.scriptingManager.getScript("test.js"));
        this.scriptingManager.removeScript("test.js");
        AssertJUnit.assertNull((Object)this.cacheManager.getCache("___script_cache").get((Object)"test.js"));
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/test.js");
        String script = CommonsTestingUtil.loadFileAsString((InputStream)is);
        this.scriptingManager.addScript("test.js", script);
        AssertJUnit.assertNotNull((Object)this.scriptingManager.getScript("test.js"));
    }

    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp=".*Script execution error.*")
    public void testWrongJavaRef() throws Exception {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/testWrongJavaRef.js");
        String script = CommonsTestingUtil.loadFileAsString((InputStream)is);
        this.scriptingManager.addScript("testWrongJavaRef.js", script);
        String result = (String)this.scriptingManager.runScript("testWrongJavaRef.js", new TaskContext().addParameter("a", (Object)"a")).get();
        AssertJUnit.assertEquals((String)"a", (String)result);
    }

    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp=".*Script execution error.*")
    public void testWrongPropertyRef() throws Exception {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/testWrongPropertyRef.js");
        String script = CommonsTestingUtil.loadFileAsString((InputStream)is);
        this.scriptingManager.addScript("testWrongPropertyRef.js", script);
        String result = (String)this.scriptingManager.runScript("testWrongPropertyRef.js").get();
        AssertJUnit.assertEquals((String)"a", (String)result);
    }

    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp=".*Compiler error for script.*")
    public void testJsCompilationError() throws Exception {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/testJsCompilationError.js");
        String script = CommonsTestingUtil.loadFileAsString((InputStream)is);
        this.scriptingManager.addScript("testJsCompilationError.js", script);
        String result = (String)this.scriptingManager.runScript("testJsCompilationError.js").get();
        AssertJUnit.assertEquals((String)"a", (String)result);
    }

    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp=".*No script named.*")
    public void testGetNonExistentScript() {
        this.scriptingManager.getScript("nonExistent.js");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp=".*Cannot find an appropriate script engine for script.*")
    public void testNonSupportedScript() {
        this.scriptingManager.addScript("Test.java", "//mode=local,language=nondescript\npublic class Test {\n      public static void main(String[] args) {\n         System.out.println(cache.get(\"test.js\"));\n      }\n   }");
        this.scriptingManager.runScript("Test.java");
    }

    public void testMapReduceScript() throws IOException, ExecutionException, InterruptedException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/wordCountStream.js");
        String script = CommonsTestingUtil.loadFileAsString((InputStream)is);
        Cache cache = this.cache(CACHE_NAME);
        ScriptingUtils.loadData((BasicCache<String, String>)cache, "/macbeth.txt");
        this.scriptingManager.addScript("wordCountStream.js", script);
        Map result = (Map)this.scriptingManager.runScript("wordCountStream.js", new TaskContext().cache(cache)).get();
        AssertJUnit.assertEquals((int)3202, (int)result.size());
        AssertJUnit.assertEquals((Object)287L, result.get("macbeth"));
    }
}

