/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.scripting.AbstractScriptingTest;
import org.infinispan.tasks.TaskContext;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scripting.ScriptingDataStoresTest")
@CleanupAfterMethod
public class ScriptingDataStoresTest
extends AbstractScriptingTest {
    static final String CACHE_NAME = "script-exec";
    protected StorageType storageType;

    protected String parameters() {
        return "[" + this.storageType + "]";
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new ScriptingDataStoresTest().withStorageType(StorageType.OFF_HEAP), new ScriptingDataStoresTest().withStorageType(StorageType.BINARY), new ScriptingDataStoresTest().withStorageType(StorageType.OBJECT)};
    }

    ScriptingDataStoresTest withStorageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    @Override
    protected String[] getScripts() {
        return new String[]{"test.js", "testExecWithoutProp.js"};
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder conf = new ConfigurationBuilder();
        conf.memory().storageType(this.storageType);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)conf);
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.memory().storageType(this.storageType);
        this.cacheManager.defineConfiguration(CACHE_NAME, builder.build());
        this.cacheManager.getCache(CACHE_NAME);
    }

    protected void clearContent() {
        this.cacheManager.getCache().clear();
    }

    public void testScriptWithParam() throws Exception {
        CompletionStage scriptStage = this.scriptingManager.runScript("test.js", new TaskContext().addParameter("a", (Object)"a"));
        String result = (String)scriptStage.toCompletableFuture().get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((String)"a", (String)result);
        AssertJUnit.assertEquals((Object)"a", (Object)this.cacheManager.getCache(CACHE_NAME).get((Object)"a"));
    }

    public void testScriptWithoutParam() throws Exception {
        String value = "javaValue";
        String key = "processValue";
        this.cacheManager.getCache(CACHE_NAME).put((Object)key, (Object)value);
        CompletionStage scriptStage = this.scriptingManager.runScript("testExecWithoutProp.js");
        String result = (String)scriptStage.toCompletableFuture().get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((String)"javaValue", (String)result);
        AssertJUnit.assertEquals((Object)(value + ":additionFromJavascript"), (Object)this.cacheManager.getCache(CACHE_NAME).get((Object)key));
    }
}

