/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting;

import java.io.InputStream;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scripting.ScriptingTest")
public class ScriptingTest
extends SingleCacheManagerTest {
    protected static final String SCRIPT_NAME = "test.js";
    protected ScriptingManager scriptingManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager();
    }

    protected void setup() throws Exception {
        super.setup();
        this.scriptingManager = (ScriptingManager)this.cacheManager.getGlobalComponentRegistry().getComponent(ScriptingManager.class);
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/test.js");){
            String script = TestingUtil.loadFileAsString((InputStream)is);
            this.scriptingManager.addScript(SCRIPT_NAME, script);
        }
    }

    public void testSimpleScript() throws Exception {
        String result = (String)this.scriptingManager.runScript(SCRIPT_NAME).get();
        AssertJUnit.assertEquals((String)"a", (String)result);
    }
}

