/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.util.EnumSet;
import java.util.concurrent.ConcurrentMap;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.concurrent.NoOpFuture;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.CacheMgmtInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.scripting.impl.CacheScriptBindings;
import org.infinispan.scripting.impl.ExecutionMode;
import org.infinispan.scripting.impl.ScriptMetadata;
import org.infinispan.scripting.impl.ScriptRunner;
import org.infinispan.scripting.impl.ScriptingInterceptor;
import org.infinispan.scripting.impl.SecurityActions;
import org.infinispan.scripting.impl.SystemBindings;
import org.infinispan.scripting.logging.Log;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.impl.CacheRoleImpl;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class ScriptingManagerImpl
implements ScriptingManager {
    public static final String SCRIPT_MANAGER_ROLE = "___script_manager";
    public static final String SCRIPT_CACHE = "___script_cache";
    private static final String DEFAULT_SCRIPT_EXTENSION = "js";
    private static final Log log = (Log)LogFactory.getLog(ScriptingManagerImpl.class, Log.class);
    EmbeddedCacheManager cacheManager;
    private ScriptEngineManager scriptEngineManager;
    private ConcurrentMap<String, ScriptEngine> scriptEnginesByExtension = CollectionFactory.makeConcurrentMap((int)2);
    private ConcurrentMap<String, ScriptEngine> scriptEnginesByLanguage = CollectionFactory.makeConcurrentMap((int)2);
    Cache<String, String> scriptCache;
    ConcurrentMap<String, CompiledScript> compiledScripts = CollectionFactory.makeConcurrentMap();
    private AuthorizationManager authzManager;
    private Marshaller marshaller;
    private static final int KEY = 0;
    private static final int VALUE = 1;

    @Inject
    public void initialize(EmbeddedCacheManager cacheManager, InternalCacheRegistry internalCacheRegistry) {
        this.cacheManager = cacheManager;
        ClassLoader classLoader = cacheManager.getCacheManagerConfiguration().classLoader();
        this.scriptEngineManager = new ScriptEngineManager(classLoader);
        internalCacheRegistry.registerInternalCache(SCRIPT_CACHE, this.getScriptCacheConfiguration().build(), EnumSet.of(InternalCacheRegistry.Flag.USER));
    }

    Cache<String, String> getScriptCache() {
        if (this.scriptCache == null) {
            this.scriptCache = this.cacheManager.getCache(SCRIPT_CACHE);
        }
        return this.scriptCache;
    }

    private ConfigurationBuilder getScriptCacheConfiguration() {
        GlobalConfiguration globalConfiguration = this.cacheManager.getGlobalComponentRegistry().getGlobalConfiguration();
        CacheMode cacheMode = globalConfiguration.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL;
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.clustering().cacheMode(cacheMode).sync().stateTransfer().fetchInMemoryState(true).awaitInitialTransfer(false).compatibility().enable().marshaller((Marshaller)new GenericJBossMarshaller()).customInterceptors().addInterceptor().interceptor((CommandInterceptor)new ScriptingInterceptor()).before(CacheMgmtInterceptor.class);
        if (globalConfiguration.security().authorization().enabled()) {
            globalConfiguration.security().authorization().roles().put(SCRIPT_MANAGER_ROLE, new CacheRoleImpl(SCRIPT_MANAGER_ROLE, new AuthorizationPermission[]{AuthorizationPermission.ALL}));
            cfg.security().authorization().enable().role(SCRIPT_MANAGER_ROLE);
        }
        return cfg;
    }

    ScriptMetadata compileScript(String name, String script) {
        ScriptMetadata metadata = this.extractMetadataFromScript(name, script);
        ScriptEngine engine = this.getEngineForScript(metadata);
        if (engine instanceof Compilable) {
            try {
                CompiledScript compiledScript = ((Compilable)((Object)engine)).compile(script);
                this.compiledScripts.put(name, compiledScript);
                return metadata;
            }
            catch (ScriptException e) {
                throw log.scriptCompilationException(e, name);
            }
        }
        return null;
    }

    @Override
    public void addScript(String name, String script) {
        ScriptMetadata metadata = this.extractMetadataFromScript(name, script);
        ScriptEngine engine = this.getEngineForScript(metadata);
        if (engine == null) {
            throw log.noScriptEngineForScript(name);
        }
        this.getScriptCache().getAdvancedCache().put((Object)name, (Object)script, (Metadata)metadata);
    }

    @Override
    public void removeScript(String name) {
        if (this.getScriptCache().remove((Object)name) == null) {
            throw log.noNamedScript(name);
        }
    }

    @Override
    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Override
    public <T> NotifyingFuture<T> runScript(String scriptName, Bindings parameters) {
        return this.runScript(scriptName, null, parameters);
    }

    @Override
    public <T> NotifyingFuture<T> runScript(String scriptName) {
        return this.runScript(scriptName, null, new SimpleBindings());
    }

    @Override
    public <T> NotifyingFuture<T> runScript(String scriptName, Cache<?, ?> cache) {
        return this.runScript(scriptName, cache, new SimpleBindings());
    }

    @Override
    public <T> NotifyingFuture<T> runScript(String scriptName, Cache<?, ?> cache, Bindings parameters) {
        if (this.authzManager != null) {
            this.authzManager.checkPermission(AuthorizationPermission.EXEC);
        }
        ScriptMetadata metadata = this.getScriptMetadata(scriptName);
        SimpleBindings systemBindings = new SimpleBindings();
        systemBindings.put(SystemBindings.CACHE_MANAGER.toString(), (Object)this.cacheManager);
        systemBindings.put(SystemBindings.SCRIPTING_MANAGER.toString(), (Object)this);
        if (cache != null) {
            systemBindings.put(SystemBindings.CACHE.toString(), (Object)cache);
        }
        CacheScriptBindings bindings = new CacheScriptBindings(systemBindings, parameters);
        String mode = metadata.property(ScriptMetadata.MetadataProperties.MODE);
        ScriptRunner runner = ExecutionMode.valueOf(mode.toUpperCase()).getRunner();
        return runner.runScript(this, metadata, bindings);
    }

    ScriptMetadata getScriptMetadata(String scriptName) {
        CacheEntry scriptEntry = SecurityActions.getCacheEntry(this.getScriptCache().getAdvancedCache(), scriptName);
        if (scriptEntry == null) {
            throw log.noNamedScript(scriptName);
        }
        ScriptMetadata metadata = (ScriptMetadata)scriptEntry.getMetadata();
        return metadata;
    }

    <T> NotifyingFuture<T> execute(ScriptMetadata metadata, Bindings bindings) {
        CompiledScript compiled = (CompiledScript)this.compiledScripts.get(metadata.name());
        try {
            if (compiled != null) {
                Object result = compiled.eval(bindings);
                return new NoOpFuture(result);
            }
            ScriptEngine engine = this.getEngineForScript(metadata);
            Object result = engine.eval((String)this.getScriptCache().get((Object)metadata.name()), bindings);
            return new NoOpFuture(result);
        }
        catch (ScriptException e) {
            throw log.scriptExecutionError(e);
        }
    }

    private ScriptMetadata extractMetadataFromScript(String name, String script) {
        ScriptMetadata.Builder metadataBuilder = new ScriptMetadata.Builder();
        metadataBuilder.property(ScriptMetadata.MetadataProperties.NAME, name);
        metadataBuilder.property(ScriptMetadata.MetadataProperties.MODE, ExecutionMode.LOCAL.toString().toLowerCase());
        int s = name.lastIndexOf(".") + 1;
        if (s == 0 || s == name.length()) {
            metadataBuilder.property(ScriptMetadata.MetadataProperties.EXTENSION, DEFAULT_SCRIPT_EXTENSION);
        } else {
            metadataBuilder.property(ScriptMetadata.MetadataProperties.EXTENSION, name.substring(s));
        }
        if (script.startsWith("//")) {
            int state = 0;
            String key = null;
            String value = null;
            StringBuilder sb = new StringBuilder();
            char ch = '\u0000';
            block12: for (int pos = 2; ch != '\n' && ch != '\r' && pos < script.length(); ++pos) {
                ch = script.charAt(pos);
                switch (state) {
                    case 0: {
                        switch (ch) {
                            case '=': {
                                key = sb.toString().toUpperCase();
                                sb = new StringBuilder();
                                state = 1;
                                continue block12;
                            }
                            case ' ': {
                                continue block12;
                            }
                        }
                        sb.append(ch);
                        continue block12;
                    }
                    case 1: {
                        switch (ch) {
                            case '\n': 
                            case '\r': 
                            case ',': {
                                value = sb.toString();
                                metadataBuilder.property(ScriptMetadata.MetadataProperties.valueOf(key), value);
                                sb = new StringBuilder();
                                state = 0;
                                continue block12;
                            }
                            case ' ': {
                                continue block12;
                            }
                        }
                        sb.append(ch);
                    }
                }
            }
        }
        return metadataBuilder.build();
    }

    ScriptEngine getEngineForScript(ScriptMetadata metadata) {
        String language = metadata.property(ScriptMetadata.MetadataProperties.LANGUAGE);
        if (language != null) {
            if (this.scriptEnginesByLanguage.containsKey(language)) {
                return (ScriptEngine)this.scriptEnginesByLanguage.get(language);
            }
            ScriptEngine engine = this.scriptEngineManager.getEngineByName(language);
            if (engine == null) {
                throw log.noEngineForScript(metadata.name());
            }
            this.scriptEnginesByLanguage.put(language, engine);
            return engine;
        }
        String extension = metadata.property(ScriptMetadata.MetadataProperties.EXTENSION);
        if (this.scriptEnginesByExtension.containsKey(extension)) {
            return (ScriptEngine)this.scriptEnginesByExtension.get(extension);
        }
        ScriptEngine engine = this.scriptEngineManager.getEngineByExtension(extension);
        if (engine == null) {
            throw log.noEngineForScript(metadata.name());
        }
        this.scriptEnginesByExtension.put(extension, engine);
        return engine;
    }
}

