/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.Buffer;
import java.nio.CharBuffer;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.infinispan.Cache;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scripting.ClusteredScriptingTest")
public class ClusteredScriptingTest
extends MultipleCacheManagersTest {
    protected void createCacheManagers() throws Exception {
        ConfigurationBuilder conf = ClusteredScriptingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        this.createCluster(conf, 2);
        this.waitForClusterToForm();
    }

    private void executeScriptOnManager(int num, String scriptName) throws InterruptedException, ExecutionException {
        ScriptingManager scriptingManager = this.getScriptingManager(this.manager(num));
        String s = (String)scriptingManager.runScript(scriptName).get();
        AssertJUnit.assertEquals((String)"a", (String)s);
    }

    public void testClusteredScriptExec() throws IOException, InterruptedException, ExecutionException {
        ScriptingManager scriptingManager = this.getScriptingManager(this.manager(0));
        this.loadScript(scriptingManager, "/test.js");
        this.executeScriptOnManager(0, "test.js");
        this.executeScriptOnManager(1, "test.js");
    }

    public void testDistExecScript() throws InterruptedException, ExecutionException, IOException {
        ScriptingManager scriptingManager = this.getScriptingManager(this.manager(0));
        this.loadScript(scriptingManager, "/distExec.js");
        NotifyingFuture resultsFuture = scriptingManager.runScript("distExec.js", this.cache(0));
        List results = (List)resultsFuture.get();
        AssertJUnit.assertEquals((int)2, (int)results.size());
        HashSet<Address> addresses = new HashSet<Address>();
        for (Address result : results) {
            addresses.add(result);
        }
        AssertJUnit.assertTrue((boolean)addresses.containsAll(this.manager(0).getMembers()));
    }

    private ScriptingManager getScriptingManager(EmbeddedCacheManager manager) {
        return (ScriptingManager)manager.getGlobalComponentRegistry().getComponent(ScriptingManager.class);
    }

    public void testMapReduce() throws Exception {
        ScriptingManager scriptingManager = this.getScriptingManager(this.manager(0));
        Cache cache = this.cache(0);
        this.loadData((Cache<String, String>)cache, "/macbeth.txt");
        this.loadScript(scriptingManager, "/wordCountMapper.js");
        this.loadScript(scriptingManager, "/wordCountReducer.js");
        this.loadScript(scriptingManager, "/wordCountCollator.js");
        NotifyingFuture resultFuture = scriptingManager.runScript("wordCountMapper.js", cache);
        LinkedHashMap results = (LinkedHashMap)resultFuture.get();
        AssertJUnit.assertEquals((int)20, (int)results.size());
        AssertJUnit.assertTrue((boolean)((Double)results.get("macbeth")).equals(287.0));
    }

    private void loadData(Cache<String, String> cache, String fileName) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(fileName)));){
            int chunkSize = 10;
            int chunkId = 0;
            CharBuffer cbuf = CharBuffer.allocate(1024 * chunkSize);
            while (bufferedReader.read(cbuf) >= 0) {
                Buffer buffer = cbuf.flip();
                String textChunk = buffer.toString();
                cache.put((Object)(fileName + chunkId++), (Object)textChunk);
                cbuf.clear();
            }
        }
    }

    private void loadScript(ScriptingManager scriptingManager, String fileName) throws IOException {
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);){
            String script = TestingUtil.loadFileAsString((InputStream)is);
            scriptingManager.addScript(fileName.replaceAll("\\/", ""), script);
        }
    }
}

