/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting;

import java.io.InputStream;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.tasks.TaskContext;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scripting.ScriptingTest")
public class ScriptingTest
extends SingleCacheManagerTest {
    protected ScriptingManager scriptingManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager();
    }

    protected String[] getScripts() {
        return new String[]{"test.js"};
    }

    protected void setup() throws Exception {
        super.setup();
        this.scriptingManager = (ScriptingManager)this.cacheManager.getGlobalComponentRegistry().getComponent(ScriptingManager.class);
        for (String scriptName : this.getScripts()) {
            try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/" + scriptName);){
                String script = TestingUtil.loadFileAsString((InputStream)is);
                this.scriptingManager.addScript(scriptName, script);
            }
        }
    }

    public void testSimpleScript() throws Exception {
        String result = (String)this.scriptingManager.runScript("test.js", new TaskContext().addParameter("a", (Object)"a")).get();
        AssertJUnit.assertEquals((String)"a", (String)result);
    }
}

