/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting;

import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.scripting.ScriptingTest;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.impl.IdentityRoleMapper;
import org.infinispan.tasks.TaskContext;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scripting.SecureScriptingTest")
public class SecureScriptingTest
extends ScriptingTest {
    static final Subject ADMIN = TestingUtil.makeSubject((String[])new String[]{"admin", "___script_manager"});
    static final Subject RUNNER = TestingUtil.makeSubject((String[])new String[]{"runner", "runner"});
    static final Subject PHEIDIPPIDES = TestingUtil.makeSubject((String[])new String[]{"pheidippides", "pheidippides"});

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        GlobalAuthorizationConfigurationBuilder globalRoles = global.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper());
        ConfigurationBuilder config = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        AuthorizationConfigurationBuilder authConfig = config.security().authorization().enable();
        globalRoles.role("runner").permission(AuthorizationPermission.EXEC).permission(AuthorizationPermission.READ).permission(AuthorizationPermission.WRITE).role("pheidippides").permission(AuthorizationPermission.EXEC).permission(AuthorizationPermission.READ).permission(AuthorizationPermission.WRITE).role("admin").permission(AuthorizationPermission.ALL);
        authConfig.role("runner").role("pheidippides").role("admin");
        return TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)global, (ConfigurationBuilder)config);
    }

    @Override
    protected String[] getScripts() {
        return new String[]{"test.js", "testRole.js"};
    }

    @Override
    protected void setup() throws Exception {
        Security.doAs((Subject)ADMIN, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                SecureScriptingTest.super.setup();
                return null;
            }
        });
    }

    protected void teardown() {
        Security.doAs((Subject)ADMIN, (PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecureScriptingTest.super.teardown();
                return null;
            }
        });
    }

    protected void clearContent() {
        Security.doAs((Subject)ADMIN, (PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecureScriptingTest.this.cacheManager.getCache().clear();
                return null;
            }
        });
    }

    @Override
    @Test(expectedExceptions={SecurityException.class, CacheException.class})
    public void testSimpleScript() throws Exception {
        String result = (String)this.scriptingManager.runScript("test.js", new TaskContext().addParameter("a", (Object)"a").cache(this.cache())).get();
        AssertJUnit.assertEquals((String)"a", (String)result);
    }

    public void testSimpleScriptWithEXECPermissions() throws Exception {
        String result = (String)Security.doAs((Subject)RUNNER, (PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                return (String)SecureScriptingTest.this.scriptingManager.runScript("test.js", new TaskContext().addParameter("a", (Object)"a").cache(SecureScriptingTest.this.cache())).get();
            }
        });
        AssertJUnit.assertEquals((String)"a", (String)result);
    }

    @Test(expectedExceptions={PrivilegedActionException.class, CacheException.class})
    public void testSimpleScriptWithEXECPermissionsWrongRole() throws Exception {
        String result = (String)Security.doAs((Subject)RUNNER, (PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                return (String)SecureScriptingTest.this.scriptingManager.runScript("testRole.js", new TaskContext().addParameter("a", (Object)"a").cache(SecureScriptingTest.this.cache())).get();
            }
        });
        AssertJUnit.assertEquals((String)"a", (String)result);
    }

    public void testSimpleScriptWithEXECPermissionsRightRole() throws Exception {
        String result = (String)Security.doAs((Subject)PHEIDIPPIDES, (PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                return (String)SecureScriptingTest.this.scriptingManager.runScript("testRole.js", new TaskContext().addParameter("a", (Object)"a").cache(SecureScriptingTest.this.cache())).get();
            }
        });
        AssertJUnit.assertEquals((String)"a", (String)result);
    }
}

