/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting;

import java.io.InputStream;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="scripting.ScriptingTaskManagerTest")
public class ScriptingTaskManagerTest
extends SingleCacheManagerTest {
    protected static final String SCRIPT_NAME = "test.js";
    protected TaskManager taskManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager();
    }

    protected void setup() throws Exception {
        super.setup();
        this.taskManager = (TaskManager)this.cacheManager.getGlobalComponentRegistry().getComponent(TaskManager.class);
        Cache scriptCache = this.cacheManager.getCache("___script_cache");
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/test.js");){
            String script = TestingUtil.loadFileAsString((InputStream)is);
            scriptCache.put((Object)SCRIPT_NAME, (Object)script);
        }
    }

    public void testTask() throws Exception {
        String result = (String)this.taskManager.runTask(SCRIPT_NAME, new TaskContext().addParameter("a", (Object)"a")).get();
        AssertJUnit.assertEquals((String)"a", (String)result);
    }
}

